// Copyright 2015-2016 Espressif Systems (Shanghai) PTE LTD
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at

//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef _EMAC_H_
#define _EMAC_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "soc.h"
#define REG_EMAC_BASE  DR_REG_EMAC_BASE

#define EMAC_DMABUSMODE_REG (REG_EMAC_BASE + 0x0000)
#define EMAC_DMAREBINCRBURST (BIT(31))
#define EMAC_DMAREBINCRBURST_M (BIT(31))
#define EMAC_DMAREBINCRBURST_V 1
#define EMAC_DMAREBINCRBURST_S 31
#define EMAC_DMACHANNELPRIOWT 0x00000003
#define EMAC_DMACHANNELPRIOWT_M (EMAC_DMACHANNELPRIOWT_V << EMAC_DMACHANNELPRIOWT_S)
#define EMAC_DMACHANNELPRIOWT_V 0x00000003
#define EMAC_DMACHANNELPRIOWT_S 28
#define EMAC_DMATXRXPRIO (BIT(27))
#define EMAC_DMATXRXPRIO_M (BIT(27))
#define EMAC_DMATXRXPRIO_V 1
#define EMAC_DMATXRXPRIO_S 27
#define EMAC_DMAMIXEDBURST (BIT(26))
#define EMAC_DMAMIXEDBURST_M (BIT(26))
#define EMAC_DMAMIXEDBURST_V 1
#define EMAC_DMAMIXEDBURST_S 26
#define EMAC_DMAADDRALIBEA (BIT(25))
#define EMAC_DMAADDRALIBEA_M (BIT(25))
#define EMAC_DMAADDRALIBEA_V 1
#define EMAC_DMAADDRALIBEA_S 25
#define EMAC_PBLX8_MODE (BIT(24))
#define EMAC_PBLX8_MODE_M (BIT(24))
#define EMAC_PBLX8_MODE_V 1
#define EMAC_PBLX8_MODE_S 24
#define EMAC_USE_SEP_PBL (BIT(23))
#define EMAC_USE_SEP_PBL_M (BIT(23))
#define EMAC_USE_SEP_PBL_V 1
#define EMAC_USE_SEP_PBL_S 23
#define EMAC_RX_DMA_PBL 0x0000003F
#define EMAC_RX_DMA_PBL_M (EMAC_RX_DMA_PBL_V << EMAC_RX_DMA_PBL_S)
#define EMAC_RX_DMA_PBL_V 0x0000003F
#define EMAC_RX_DMA_PBL_S 17
#define EMAC_FIXED_BURST (BIT(16))
#define EMAC_FIXED_BURST_M (BIT(16))
#define EMAC_FIXED_BURST_V 1
#define EMAC_FIXED_BURST_S 16
#define EMAC_PRI_RATIO 0x00000003
#define EMAC_PRI_RATIO_M (EMAC_PRI_RATIO_V << EMAC_PRI_RATIO_S)
#define EMAC_PRI_RATIO_V 0x00000003
#define EMAC_PRI_RATIO_S 14
#define EMAC_PROG_BURST_LEN 0x0000003F
#define EMAC_PROG_BURST_LEN_M (EMAC_PROG_BURST_LEN_V << EMAC_PROG_BURST_LEN_S)
#define EMAC_PROG_BURST_LEN_V 0x0000003F
#define EMAC_PROG_BURST_LEN_S 8
#define EMAC_ALT_DESC_SIZE (BIT(7))
#define EMAC_ALT_DESC_SIZE_M (BIT(7))
#define EMAC_ALT_DESC_SIZE_V 1
#define EMAC_ALT_DESC_SIZE_S 7
#define EMAC_DESC_SKIP_LEN 0x0000001F
#define EMAC_DESC_SKIP_LEN_M (EMAC_DESC_SKIP_LEN_V << EMAC_DESC_SKIP_LEN_S)
#define EMAC_DESC_SKIP_LEN_V 0x0000001F
#define EMAC_DESC_SKIP_LEN_S 2
#define EMAC_DMA_ARB_SCH (BIT(1))
#define EMAC_DMA_ARB_SCH_M (BIT(1))
#define EMAC_DMA_ARB_SCH_V 1
#define EMAC_DMA_ARB_SCH_S 1
#define EMAC_SW_RST (BIT(0))
#define EMAC_SW_RST_M (BIT(0))
#define EMAC_SW_RST_V 1
#define EMAC_SW_RST_S 0

#define EMAC_DMATXPOLLDEMAND_REG (REG_EMAC_BASE + 0x0004)
#define EMAC_TRANS_POLL_DEMAND 0xFFFFFFFF
#define EMAC_TRANS_POLL_DEMAND_M (EMAC_TRANS_POLL_DEMAND_V << EMAC_TRANS_POLL_DEMAND_S)
#define EMAC_TRANS_POLL_DEMAND_V 0xFFFFFFFF
#define EMAC_TRANS_POLL_DEMAND_S 0

#define EMAC_DMARXPOLLDEMAND_REG (REG_EMAC_BASE + 0x0008)
#define EMAC_RECV_POLL_DEMAND 0xFFFFFFFF
#define EMAC_RECV_POLL_DEMAND_M (EMAC_RECV_POLL_DEMAND_V << EMAC_RECV_POLL_DEMAND_S)
#define EMAC_RECV_POLL_DEMAND_V 0xFFFFFFFF
#define EMAC_RECV_POLL_DEMAND_S 0

#define EMAC_DMARXBASEADDR_REG (REG_EMAC_BASE + 0x000C)
#define EMAC_START_RECV_LIST 0xFFFFFFFF
#define EMAC_START_RECV_LIST_M (EMAC_START_RECV_LIST_V << EMAC_START_RECV_LIST_S)
#define EMAC_START_RECV_LIST_V 0xFFFFFFFF
#define EMAC_START_RECV_LIST_S 0

#define EMAC_DMATXBASEADDR_REG (REG_EMAC_BASE + 0x0010)
#define EMAC_START_TRANS_LIST 0xFFFFFFFF
#define EMAC_START_TRANS_LIST_M (EMAC_START_TRANS_LIST_V << EMAC_START_TRANS_LIST_S)
#define EMAC_START_TRANS_LIST_V 0xFFFFFFFF
#define EMAC_START_TRANS_LIST_S 0

#define EMAC_DMASTATUS_REG (REG_EMAC_BASE + 0x0014)
#define EMAC_GMAC_LPI_INT (BIT(30))
#define EMAC_GMAC_LPI_INT_M (BIT(30))
#define EMAC_GMAC_LPI_INT_V 1
#define EMAC_GMAC_LPI_INT_S 30
#define EMAC_TS_TRI_INT (BIT(29))
#define EMAC_TS_TRI_INT_M (BIT(29))
#define EMAC_TS_TRI_INT_V 1
#define EMAC_TS_TRI_INT_S 29
#define EMAC_GMAC_PMT_INT (BIT(28))
#define EMAC_GMAC_PMT_INT_M (BIT(28))
#define EMAC_GMAC_PMT_INT_V 1
#define EMAC_GMAC_PMT_INT_S 28
#define EMAC_GMAC_MMC_INT (BIT(27))
#define EMAC_GMAC_MMC_INT_M (BIT(27))
#define EMAC_GMAC_MMC_INT_V 1
#define EMAC_GMAC_MMC_INT_S 27
#define EMAC_GMAC_LINE_INF_INT (BIT(26))
#define EMAC_GMAC_LINE_INF_INT_M (BIT(26))
#define EMAC_GMAC_LINE_INF_INT_V 1
#define EMAC_GMAC_LINE_INF_INT_S 26
#define EMAC_ERROR_BITS 0x00000007
#define EMAC_ERROR_BITS_M (EMAC_ERROR_BITS_V << EMAC_ERROR_BITS_S)
#define EMAC_ERROR_BITS_V 0x00000007
#define EMAC_ERROR_BITS_S 23
#define EMAC_TRANS_PROC_STATE 0x00000007
#define EMAC_TRANS_PROC_STATE_M (EMAC_TRANS_PROC_STATE_V << EMAC_TRANS_PROC_STATE_S)
#define EMAC_TRANS_PROC_STATE_V 0x00000007
#define EMAC_TRANS_PROC_STATE_S 20
#define EMAC_RECV_PROC_STATE 0x00000007
#define EMAC_RECV_PROC_STATE_M (EMAC_RECV_PROC_STATE_V << EMAC_RECV_PROC_STATE_S)
#define EMAC_RECV_PROC_STATE_V 0x00000007
#define EMAC_RECV_PROC_STATE_S 17
#define EMAC_NORM_INT_SUMM (BIT(16))
#define EMAC_NORM_INT_SUMM_M (BIT(16))
#define EMAC_NORM_INT_SUMM_V 1
#define EMAC_NORM_INT_SUMM_S 16
#define EMAC_ABN_INT_SUMM (BIT(15))
#define EMAC_ABN_INT_SUMM_M (BIT(15))
#define EMAC_ABN_INT_SUMM_V 1
#define EMAC_ABN_INT_SUMM_S 15
#define EMAC_EARLY_RECV_INT (BIT(14))
#define EMAC_EARLY_RECV_INT_M (BIT(14))
#define EMAC_EARLY_RECV_INT_V 1
#define EMAC_EARLY_RECV_INT_S 14
#define EMAC_FATAL_BUS_ERR_INT (BIT(13))
#define EMAC_FATAL_BUS_ERR_INT_M (BIT(13))
#define EMAC_FATAL_BUS_ERR_INT_V 1
#define EMAC_FATAL_BUS_ERR_INT_S 13
#define EMAC_EARLY_TRANS_INT (BIT(10))
#define EMAC_EARLY_TRANS_INT_M (BIT(10))
#define EMAC_EARLY_TRANS_INT_V 1
#define EMAC_EARLY_TRANS_INT_S 10
#define EMAC_RECV_WDT_TO (BIT(9))
#define EMAC_RECV_WDT_TO_M (BIT(9))
#define EMAC_RECV_WDT_TO_V 1
#define EMAC_RECV_WDT_TO_S 9
#define EMAC_RECV_PROC_STOP (BIT(8))
#define EMAC_RECV_PROC_STOP_M (BIT(8))
#define EMAC_RECV_PROC_STOP_V 1
#define EMAC_RECV_PROC_STOP_S 8
#define EMAC_RECV_BUF_UNAVAIL (BIT(7))
#define EMAC_RECV_BUF_UNAVAIL_M (BIT(7))
#define EMAC_RECV_BUF_UNAVAIL_V 1
#define EMAC_RECV_BUF_UNAVAIL_S 7
#define EMAC_RECV_INT (BIT(6))
#define EMAC_RECV_INT_M (BIT(6))
#define EMAC_RECV_INT_V 1
#define EMAC_RECV_INT_S 6
#define EMAC_TRANS_UNDFLOW (BIT(5))
#define EMAC_TRANS_UNDFLOW_M (BIT(5))
#define EMAC_TRANS_UNDFLOW_V 1
#define EMAC_TRANS_UNDFLOW_S 5
#define EMAC_RECV_OVFLOW (BIT(4))
#define EMAC_RECV_OVFLOW_M (BIT(4))
#define EMAC_RECV_OVFLOW_V 1
#define EMAC_RECV_OVFLOW_S 4
#define EMAC_TRANS_JABBER_TO (BIT(3))
#define EMAC_TRANS_JABBER_TO_M (BIT(3))
#define EMAC_TRANS_JABBER_TO_V 1
#define EMAC_TRANS_JABBER_TO_S 3
#define EMAC_TRANS_BUF_UNAVAIL (BIT(2))
#define EMAC_TRANS_BUF_UNAVAIL_M (BIT(2))
#define EMAC_TRANS_BUF_UNAVAIL_V 1
#define EMAC_TRANS_BUF_UNAVAIL_S 2
#define EMAC_TRANS_PROC_STOP (BIT(1))
#define EMAC_TRANS_PROC_STOP_M (BIT(1))
#define EMAC_TRANS_PROC_STOP_V 1
#define EMAC_TRANS_PROC_STOP_S 1
#define EMAC_TRANS_INT (BIT(0))
#define EMAC_TRANS_INT_M (BIT(0))
#define EMAC_TRANS_INT_V 1
#define EMAC_TRANS_INT_S 0

#define EMAC_DMAOPERATION_MODE_REG (REG_EMAC_BASE + 0x0018)
#define EMAC_DIS_DROP_TCPIP_CHKSUM_ERR_FRAM (BIT(26))
#define EMAC_DIS_DROP_TCPIP_CHKSUM_ERR_FRAM_M (BIT(26))
#define EMAC_DIS_DROP_TCPIP_CHKSUM_ERR_FRAM_V 1
#define EMAC_DIS_DROP_TCPIP_CHKSUM_ERR_FRAM_S 26
#define EMAC_RECV_STORE_FORWARD (BIT(25))
#define EMAC_RECV_STORE_FORWARD_M (BIT(25))
#define EMAC_RECV_STORE_FORWARD_V 1
#define EMAC_RECV_STORE_FORWARD_S 25
#define EMAC_DIS_FLUSH_RECV_FRAMES (BIT(24))
#define EMAC_DIS_FLUSH_RECV_FRAMES_M (BIT(24))
#define EMAC_DIS_FLUSH_RECV_FRAMES_V 1
#define EMAC_DIS_FLUSH_RECV_FRAMES_S 24
#define EMAC_MSB_THRESHOLD_ACTIVATING_FLOW_CONTROL (BIT(23))
#define EMAC_MSB_THRESHOLD_ACTIVATING_FLOW_CONTROL_M (BIT(23))
#define EMAC_MSB_THRESHOLD_ACTIVATING_FLOW_CONTROL_V 1
#define EMAC_MSB_THRESHOLD_ACTIVATING_FLOW_CONTROL_S 23
#define EMAC_MSB_THRESHOLD_DEACTIVATING_FLOW_CONTROL (BIT(22))
#define EMAC_MSB_THRESHOLD_DEACTIVATING_FLOW_CONTROL_M (BIT(22))
#define EMAC_MSB_THRESHOLD_DEACTIVATING_FLOW_CONTROL_V 1
#define EMAC_MSB_THRESHOLD_DEACTIVATING_FLOW_CONTROL_S 22
#define EMAC_TRANSMIT_STORE_FORWARD (BIT(21))
#define EMAC_TRANSMIT_STORE_FORWARD_M (BIT(21))
#define EMAC_TRANSMIT_STORE_FORWARD_V 1
#define EMAC_TRANSMIT_STORE_FORWARD_S 21
#define EMAC_FLUSH_TRANSMIT_FIFO (BIT(20))
#define EMAC_FLUSH_TRANSMIT_FIFO_M (BIT(20))
#define EMAC_FLUSH_TRANSMIT_FIFO_V 1
#define EMAC_FLUSH_TRANSMIT_FIFO_S 20
#define EMAC_TRANSMIT_THRESHOLD_CONTROL 0x00000007
#define EMAC_TRANSMIT_THRESHOLD_CONTROL_M (EMAC_TRANSMIT_THRESHOLD_CONTROL_V << EMAC_TRANSMIT_THRESHOLD_CONTROL_S)
#define EMAC_TRANSMIT_THRESHOLD_CONTROL_V 0x00000007
#define EMAC_TRANSMIT_THRESHOLD_CONTROL_S 14
#define EMAC_START_STOP_TRANSMISSION_COMMAND (BIT(13))
#define EMAC_START_STOP_TRANSMISSION_COMMAND_M (BIT(13))
#define EMAC_START_STOP_TRANSMISSION_COMMAND_V 1
#define EMAC_START_STOP_TRANSMISSION_COMMAND_S 13
#define EMAC_THRESHOLD_DEACTIVATING_FLOW_CONTROL 0x00000003
#define EMAC_THRESHOLD_DEACTIVATING_FLOW_CONTROL_M (EMAC_THRESHOLD_DEACTIVATING_FLOW_CONTROL_V << EMAC_THRESHOLD_DEACTIVATING_FLOW_CONTROL_S)
#define EMAC_THRESHOLD_DEACTIVATING_FLOW_CONTROL_V 0x00000003
#define EMAC_THRESHOLD_DEACTIVATING_FLOW_CONTROL_S 11
#define EMAC_THRESHOLD_ACTIVATING_FLOW_CONTROL 0x00000003
#define EMAC_THRESHOLD_ACTIVATING_FLOW_CONTROL_M (EMAC_THRESHOLD_ACTIVATING_FLOW_CONTROL_V << EMAC_THRESHOLD_ACTIVATING_FLOW_CONTROL_S)
#define EMAC_THRESHOLD_ACTIVATING_FLOW_CONTROL_V 0x00000003
#define EMAC_THRESHOLD_ACTIVATING_FLOW_CONTROL_S 9
#define EMAC_ENABLE_HW_FLOW_CONTROL (BIT(8))
#define EMAC_ENABLE_HW_FLOW_CONTROL_M (BIT(8))
#define EMAC_ENABLE_HW_FLOW_CONTROL_V 1
#define EMAC_ENABLE_HW_FLOW_CONTROL_S 8
#define EMAC_FORWARD_ERROR_FRAMES (BIT(7))
#define EMAC_FORWARD_ERROR_FRAMES_M (BIT(7))
#define EMAC_FORWARD_ERROR_FRAMES_V 1
#define EMAC_FORWARD_ERROR_FRAMES_S 7
#define EMAC_FORWARD_UNDERSIZED_GOOD_FRAMES (BIT(6))
#define EMAC_FORWARD_UNDERSIZED_GOOD_FRAMES_M (BIT(6))
#define EMAC_FORWARD_UNDERSIZED_GOOD_FRAMES_V 1
#define EMAC_FORWARD_UNDERSIZED_GOOD_FRAMES_S 6
#define EMAC_DROP_GIANT_FRAMES (BIT(5))
#define EMAC_DROP_GIANT_FRAMES_M (BIT(5))
#define EMAC_DROP_GIANT_FRAMES_V 1
#define EMAC_DROP_GIANT_FRAMES_S 5
#define EMAC_RECEIVE_THRESHOLD_CONTROL 0x00000003
#define EMAC_RECEIVE_THRESHOLD_CONTROL_M (EMAC_RECEIVE_THRESHOLD_CONTROL_V << EMAC_RECEIVE_THRESHOLD_CONTROL_S)
#define EMAC_RECEIVE_THRESHOLD_CONTROL_V 0x00000003
#define EMAC_RECEIVE_THRESHOLD_CONTROL_S 3
#define EMAC_OPERATE_SECOND_FRAME (BIT(2))
#define EMAC_OPERATE_SECOND_FRAME_M (BIT(2))
#define EMAC_OPERATE_SECOND_FRAME_V 1
#define EMAC_OPERATE_SECOND_FRAME_S 2
#define EMAC_START_STOP_RECEIVE (BIT(1))
#define EMAC_START_STOP_RECEIVE_M (BIT(1))
#define EMAC_START_STOP_RECEIVE_V 1
#define EMAC_START_STOP_RECEIVE_S 1

#define EMAC_DMAINTERRUPT_EN_REG (REG_EMAC_BASE + 0x001C)
#define EMAC_NORMAL_INTERRUPT_SUMMARY_ENABLE (BIT(16))
#define EMAC_NORMAL_INTERRUPT_SUMMARY_ENABLE_M (BIT(16))
#define EMAC_NORMAL_INTERRUPT_SUMMARY_ENABLE_V 1
#define EMAC_NORMAL_INTERRUPT_SUMMARY_ENABLE_S 16
#define EMAC_ABNORMAL_INTERRUPT_SUMMARY_ENABLE (BIT(15))
#define EMAC_ABNORMAL_INTERRUPT_SUMMARY_ENABLE_M (BIT(15))
#define EMAC_ABNORMAL_INTERRUPT_SUMMARY_ENABLE_V 1
#define EMAC_ABNORMAL_INTERRUPT_SUMMARY_ENABLE_S 15
#define EMAC_EARLY_RECEIVE_INTERRUPT_ENABLE (BIT(14))
#define EMAC_EARLY_RECEIVE_INTERRUPT_ENABLE_M (BIT(14))
#define EMAC_EARLY_RECEIVE_INTERRUPT_ENABLE_V 1
#define EMAC_EARLY_RECEIVE_INTERRUPT_ENABLE_S 14
#define EMAC_FATAL_BUS_ERROR_ENABLE (BIT(13))
#define EMAC_FATAL_BUS_ERROR_ENABLE_M (BIT(13))
#define EMAC_FATAL_BUS_ERROR_ENABLE_V 1
#define EMAC_FATAL_BUS_ERROR_ENABLE_S 13
#define EMAC_EARLY_TRANSMIT_INTERRUPT_ENABLE (BIT(10))
#define EMAC_EARLY_TRANSMIT_INTERRUPT_ENABLE_M (BIT(10))
#define EMAC_EARLY_TRANSMIT_INTERRUPT_ENABLE_V 1
#define EMAC_EARLY_TRANSMIT_INTERRUPT_ENABLE_S 10
#define EMAC_RECEIVE_WATCHDOG_TIMEOUT_ENABLE (BIT(9))
#define EMAC_RECEIVE_WATCHDOG_TIMEOUT_ENABLE_M (BIT(9))
#define EMAC_RECEIVE_WATCHDOG_TIMEOUT_ENABLE_V 1
#define EMAC_RECEIVE_WATCHDOG_TIMEOUT_ENABLE_S 9
#define EMAC_RECEIVE_STOPPED_ENABLE (BIT(8))
#define EMAC_RECEIVE_STOPPED_ENABLE_M (BIT(8))
#define EMAC_RECEIVE_STOPPED_ENABLE_V 1
#define EMAC_RECEIVE_STOPPED_ENABLE_S 8
#define EMAC_RECEIVE_BUFFER_UNAVAILABLE_ENABLE (BIT(7))
#define EMAC_RECEIVE_BUFFER_UNAVAILABLE_ENABLE_M (BIT(7))
#define EMAC_RECEIVE_BUFFER_UNAVAILABLE_ENABLE_V 1
#define EMAC_RECEIVE_BUFFER_UNAVAILABLE_ENABLE_S 7
#define EMAC_RECEIVE_INTERRUPT_ENABLE (BIT(6))
#define EMAC_RECEIVE_INTERRUPT_ENABLE_M (BIT(6))
#define EMAC_RECEIVE_INTERRUPT_ENABLE_V 1
#define EMAC_RECEIVE_INTERRUPT_ENABLE_S 6
#define EMAC_UNDERFLOW_INTERRUPT_ENABLE (BIT(5))
#define EMAC_UNDERFLOW_INTERRUPT_ENABLE_M (BIT(5))
#define EMAC_UNDERFLOW_INTERRUPT_ENABLE_V 1
#define EMAC_UNDERFLOW_INTERRUPT_ENABLE_S 5
#define EMAC_OVERFLOW_INTERRUPT_ENABLE (BIT(4))
#define EMAC_OVERFLOW_INTERRUPT_ENABLE_M (BIT(4))
#define EMAC_OVERFLOW_INTERRUPT_ENABLE_V 1
#define EMAC_OVERFLOW_INTERRUPT_ENABLE_S 4
#define EMAC_TRANSMIT_JABBER_TIMEOUT_ENABLE (BIT(3))
#define EMAC_TRANSMIT_JABBER_TIMEOUT_ENABLE_M (BIT(3))
#define EMAC_TRANSMIT_JABBER_TIMEOUT_ENABLE_V 1
#define EMAC_TRANSMIT_JABBER_TIMEOUT_ENABLE_S 3
#define EMAC_TRANSMIT_BUFFER_UNAVAILABLE_ENABLE (BIT(2))
#define EMAC_TRANSMIT_BUFFER_UNAVAILABLE_ENABLE_M (BIT(2))
#define EMAC_TRANSMIT_BUFFER_UNAVAILABLE_ENABLE_V 1
#define EMAC_TRANSMIT_BUFFER_UNAVAILABLE_ENABLE_S 2
#define EMAC_TRANSMIT_STOPPED_ENABLE (BIT(1))
#define EMAC_TRANSMIT_STOPPED_ENABLE_M (BIT(1))
#define EMAC_TRANSMIT_STOPPED_ENABLE_V 1
#define EMAC_TRANSMIT_STOPPED_ENABLE_S 1
#define EMAC_TRANSMIT_INTERRUPT_ENABLE (BIT(0))
#define EMAC_TRANSMIT_INTERRUPT_ENABLE_M (BIT(0))
#define EMAC_TRANSMIT_INTERRUPT_ENABLE_V 1
#define EMAC_TRANSMIT_INTERRUPT_ENABLE_S 0

#define EMAC_DMAMISSEDFR_REG (REG_EMAC_BASE + 0x0020)
#define EMAC_OVERFLOW_BIT_FIFO_OVERFLOW_COUNTER (BIT(28))
#define EMAC_OVERFLOW_BIT_FIFO_OVERFLOW_COUNTER_M (BIT(28))
#define EMAC_OVERFLOW_BIT_FIFO_OVERFLOW_COUNTER_V 1
#define EMAC_OVERFLOW_BIT_FIFO_OVERFLOW_COUNTER_S 28
#define EMAC_OVERFLOW_FRAME_COUNTER 0x000007FF
#define EMAC_OVERFLOW_FRAME_COUNTER_M (EMAC_OVERFLOW_FRAME_COUNTER_V << EMAC_OVERFLOW_FRAME_COUNTER_S)
#define EMAC_OVERFLOW_FRAME_COUNTER_V 0x000007FF
#define EMAC_OVERFLOW_FRAME_COUNTER_S 17
#define EMAC_OVERFLOW_BIT_MISSED_FRAME_COUNTER (BIT(16))
#define EMAC_OVERFLOW_BIT_MISSED_FRAME_COUNTER_M (BIT(16))
#define EMAC_OVERFLOW_BIT_MISSED_FRAME_COUNTER_V 1
#define EMAC_OVERFLOW_BIT_MISSED_FRAME_COUNTER_S 16
#define EMAC_MISSED_FRAME_COUNTER 0x0000FFFF
#define EMAC_MISSED_FRAME_COUNTER_M (EMAC_MISSED_FRAME_COUNTER_V << EMAC_MISSED_FRAME_COUNTER_S)
#define EMAC_MISSED_FRAME_COUNTER_V 0x0000FFFF
#define EMAC_MISSED_FRAME_COUNTER_S 0

#define EMAC_DMARECEIVE_INTERRUPT_WATCHDOG_TIMER_REG (REG_EMAC_BASE + 0x0024)
#define EMAC_RI_WATCHDOG_TIMER_COUNT 0x000000FF
#define EMAC_RI_WATCHDOG_TIMER_COUNT_M (EMAC_RI_WATCHDOG_TIMER_COUNT_V << EMAC_RI_WATCHDOG_TIMER_COUNT_S)
#define EMAC_RI_WATCHDOG_TIMER_COUNT_V 0x000000FF
#define EMAC_RI_WATCHDOG_TIMER_COUNT_S 0

#define EMAC_DMATXCURRDESC_REG (REG_EMAC_BASE + 0x0048)
#define EMAC_HOST_TRANSMIT_DESCRIPTOR_ADDRESS_POINTER 0xFFFFFFFF
#define EMAC_HOST_TRANSMIT_DESCRIPTOR_ADDRESS_POINTER_M (EMAC_HOST_TRANSMIT_DESCRIPTOR_ADDRESS_POINTER_V << EMAC_HOST_TRANSMIT_DESCRIPTOR_ADDRESS_POINTER_S)
#define EMAC_HOST_TRANSMIT_DESCRIPTOR_ADDRESS_POINTER_V 0xFFFFFFFF
#define EMAC_HOST_TRANSMIT_DESCRIPTOR_ADDRESS_POINTER_S 0

#define EMAC_DMARXCURRDESC_REG (REG_EMAC_BASE + 0x004C)
#define EMAC_HOST_RECEIVE_DESCRIPTOR_ADDRESS_POINTER 0xFFFFFFFF
#define EMAC_HOST_RECEIVE_DESCRIPTOR_ADDRESS_POINTER_M (EMAC_HOST_RECEIVE_DESCRIPTOR_ADDRESS_POINTER_V << EMAC_HOST_RECEIVE_DESCRIPTOR_ADDRESS_POINTER_S)
#define EMAC_HOST_RECEIVE_DESCRIPTOR_ADDRESS_POINTER_V 0xFFFFFFFF
#define EMAC_HOST_RECEIVE_DESCRIPTOR_ADDRESS_POINTER_S 0

#define EMAC_DMATXCURRADDR_BUF_REG (REG_EMAC_BASE + 0x0050)
#define EMAC_HOST_TRANSMIT_BUFFER_ADDRESS_POINTER 0xFFFFFFFF
#define EMAC_HOST_TRANSMIT_BUFFER_ADDRESS_POINTER_M (EMAC_HOST_TRANSMIT_BUFFER_ADDRESS_POINTER_V << EMAC_HOST_TRANSMIT_BUFFER_ADDRESS_POINTER_S)
#define EMAC_HOST_TRANSMIT_BUFFER_ADDRESS_POINTER_V 0xFFFFFFFF
#define EMAC_HOST_TRANSMIT_BUFFER_ADDRESS_POINTER_S 0

#define EMAC_DMARXCURRADDR_BUF_REG (REG_EMAC_BASE + 0x0054)
#define EMAC_HOST_RECEIVE_BUFFER_ADDRESS_POINTER 0xFFFFFFFF
#define EMAC_HOST_RECEIVE_BUFFER_ADDRESS_POINTER_M (EMAC_HOST_RECEIVE_BUFFER_ADDRESS_POINTER_V << EMAC_HOST_RECEIVE_BUFFER_ADDRESS_POINTER_S)
#define EMAC_HOST_RECEIVE_BUFFER_ADDRESS_POINTER_V 0xFFFFFFFF
#define EMAC_HOST_RECEIVE_BUFFER_ADDRESS_POINTER_S 0

#define EMAC_DMAHWFEATURE_REG (REG_EMAC_BASE + 0x0058)
#define EMAC_SELECTED_PHY_INTERFACE 0x00000007
#define EMAC_SELECTED_PHY_INTERFACE_M (EMAC_SELECTED_PHY_INTERFACE_V << EMAC_SELECTED_PHY_INTERFACE_S)
#define EMAC_SELECTED_PHY_INTERFACE_V 0x00000007
#define EMAC_SELECTED_PHY_INTERFACE_S 28
#define EMAC_SOURCE_ADDRESS_VLAN_INSERTION (BIT(27))
#define EMAC_SOURCE_ADDRESS_VLAN_INSERTION_M (BIT(27))
#define EMAC_SOURCE_ADDRESS_VLAN_INSERTION_V 1
#define EMAC_SOURCE_ADDRESS_VLAN_INSERTION_S 27
#define EMAC_FLEXIBLE_PULSE_PER_SECOND_OUTPUT (BIT(26))
#define EMAC_FLEXIBLE_PULSE_PER_SECOND_OUTPUT_M (BIT(26))
#define EMAC_FLEXIBLE_PULSE_PER_SECOND_OUTPUT_V 1
#define EMAC_FLEXIBLE_PULSE_PER_SECOND_OUTPUT_S 26
#define EMAC_TIMESTAMPING_INTERNAL_SYSTEM_TIME (BIT(25))
#define EMAC_TIMESTAMPING_INTERNAL_SYSTEM_TIME_M (BIT(25))
#define EMAC_TIMESTAMPING_INTERNAL_SYSTEM_TIME_V 1
#define EMAC_TIMESTAMPING_INTERNAL_SYSTEM_TIME_S 25
#define EMAC_ENHANCED_DESCRIPTOR (BIT(24))
#define EMAC_ENHANCED_DESCRIPTOR_M (BIT(24))
#define EMAC_ENHANCED_DESCRIPTOR_V 1
#define EMAC_ENHANCED_DESCRIPTOR_S 24
#define EMAC_NUMBER_ADDITIONAL_TX_CHANNELS 0x00000003
#define EMAC_NUMBER_ADDITIONAL_TX_CHANNELS_M (EMAC_NUMBER_ADDITIONAL_TX_CHANNELS_V << EMAC_NUMBER_ADDITIONAL_TX_CHANNELS_S)
#define EMAC_NUMBER_ADDITIONAL_TX_CHANNELS_V 0x00000003
#define EMAC_NUMBER_ADDITIONAL_TX_CHANNELS_S 22
#define EMAC_NUMBER_ADDITIONAL_RX_CHANNELS 0x00000003
#define EMAC_NUMBER_ADDITIONAL_RX_CHANNELS_M (EMAC_NUMBER_ADDITIONAL_RX_CHANNELS_V << EMAC_NUMBER_ADDITIONAL_RX_CHANNELS_S)
#define EMAC_NUMBER_ADDITIONAL_RX_CHANNELS_V 0x00000003
#define EMAC_NUMBER_ADDITIONAL_RX_CHANNELS_S 20
#define EMAC_RXFIFOSIZE (BIT(19))
#define EMAC_RXFIFOSIZE_M (BIT(19))
#define EMAC_RXFIFOSIZE_V 1
#define EMAC_RXFIFOSIZE_S 19
#define EMAC_IP_CHECKSUM_OFFLOAD_TYPE2 (BIT(18))
#define EMAC_IP_CHECKSUM_OFFLOAD_TYPE2_M (BIT(18))
#define EMAC_IP_CHECKSUM_OFFLOAD_TYPE2_V 1
#define EMAC_IP_CHECKSUM_OFFLOAD_TYPE2_S 18
#define EMAC_IP_CHECKSUM_OFFLOAD_TYPE1 (BIT(17))
#define EMAC_IP_CHECKSUM_OFFLOAD_TYPE1_M (BIT(17))
#define EMAC_IP_CHECKSUM_OFFLOAD_TYPE1_V 1
#define EMAC_IP_CHECKSUM_OFFLOAD_TYPE1_S 17
#define EMAC_CHECKSUM_OFFLOAD_TX (BIT(16))
#define EMAC_CHECKSUM_OFFLOAD_TX_M (BIT(16))
#define EMAC_CHECKSUM_OFFLOAD_TX_V 1
#define EMAC_CHECKSUM_OFFLOAD_TX_S 16
#define EMAC_AV_FEATURE_SEL (BIT(15))
#define EMAC_AV_FEATURE_SEL_M (BIT(15))
#define EMAC_AV_FEATURE_SEL_V 1
#define EMAC_AV_FEATURE_SEL_S 15
#define EMAC_EEE_SEL (BIT(14))
#define EMAC_EEE_SEL_M (BIT(14))
#define EMAC_EEE_SEL_V 1
#define EMAC_EEE_SEL_S 14
#define EMAC_TSVER2_SEL (BIT(13))
#define EMAC_TSVER2_SEL_M (BIT(13))
#define EMAC_TSVER2_SEL_V 1
#define EMAC_TSVER2_SEL_S 13
#define EMAC_TSVER1_SEL (BIT(12))
#define EMAC_TSVER1_SEL_M (BIT(12))
#define EMAC_TSVER1_SEL_V 1
#define EMAC_TSVER1_SEL_S 12
#define EMAC_MMC_SEL (BIT(11))
#define EMAC_MMC_SEL_M (BIT(11))
#define EMAC_MMC_SEL_V 1
#define EMAC_MMC_SEL_S 11
#define EMAC_MGK_SEL (BIT(10))
#define EMAC_MGK_SEL_M (BIT(10))
#define EMAC_MGK_SEL_V 1
#define EMAC_MGK_SEL_S 10
#define EMAC_RWK_SEL (BIT(9))
#define EMAC_RWK_SEL_M (BIT(9))
#define EMAC_RWK_SEL_V 1
#define EMAC_RWK_SEL_S 9
#define EMAC_SMA_SEL (BIT(8))
#define EMAC_SMA_SEL_M (BIT(8))
#define EMAC_SMA_SEL_V 1
#define EMAC_SMA_SEL_S 8
#define EMAC_L3L4FLTR_EN (BIT(7))
#define EMAC_L3L4FLTR_EN_M (BIT(7))
#define EMAC_L3L4FLTR_EN_V 1
#define EMAC_L3L4FLTR_EN_S 7
#define EMAC_PCS_SEL (BIT(6))
#define EMAC_PCS_SEL_M (BIT(6))
#define EMAC_PCS_SEL_V 1
#define EMAC_PCS_SEL_S 6
#define EMAC_ADDMACADR_SEL (BIT(5))
#define EMAC_ADDMACADR_SEL_M (BIT(5))
#define EMAC_ADDMACADR_SEL_V 1
#define EMAC_ADDMACADR_SEL_S 5
#define EMAC_HASH_SEL (BIT(4))
#define EMAC_HASH_SEL_M (BIT(4))
#define EMAC_HASH_SEL_V 1
#define EMAC_HASH_SEL_S 4
#define EMAC_EXTHASH_EN (BIT(3))
#define EMAC_EXTHASH_EN_M (BIT(3))
#define EMAC_EXTHASH_EN_V 1
#define EMAC_EXTHASH_EN_S 3
#define EMAC_HD_SEL (BIT(2))
#define EMAC_HD_SEL_M (BIT(2))
#define EMAC_HD_SEL_V 1
#define EMAC_HD_SEL_S 2
#define EMAC_GMII_SEL (BIT(1))
#define EMAC_GMII_SEL_M (BIT(1))
#define EMAC_GMII_SEL_V 1
#define EMAC_GMII_SEL_S 1
#define EMAC_MII_SEL (BIT(0))
#define EMAC_MII_SEL_M (BIT(0))
#define EMAC_MII_SEL_V 1
#define EMAC_MII_SEL_S 0

#define EMAC_DMASLOTFNCTRLSTS_REG (REG_EMAC_BASE + 0x0130)
#define EMAC_REFERENCE_SLOT_NUMBER 0x0000000F
#define EMAC_REFERENCE_SLOT_NUMBER_M (EMAC_REFERENCE_SLOT_NUMBER_V << EMAC_REFERENCE_SLOT_NUMBER_S)
#define EMAC_REFERENCE_SLOT_NUMBER_V 0x0000000F
#define EMAC_REFERENCE_SLOT_NUMBER_S 16
#define EMAC_ADVANCE_SLOT_CHECK (BIT(1))
#define EMAC_ADVANCE_SLOT_CHECK_M (BIT(1))
#define EMAC_ADVANCE_SLOT_CHECK_V 1
#define EMAC_ADVANCE_SLOT_CHECK_S 1
#define EMAC_ENABLE_SLOT_COMPARISON (BIT(0))
#define EMAC_ENABLE_SLOT_COMPARISON_M (BIT(0))
#define EMAC_ENABLE_SLOT_COMPARISON_V 1
#define EMAC_ENABLE_SLOT_COMPARISON_S 0

#define EMAC_DMACHANNELCTRL_REG (REG_EMAC_BASE + 0x0160)
#define EMAC_AVERAGE_BITS_PER_SLOT_INTERRUPT_ENABLE (BIT(17))
#define EMAC_AVERAGE_BITS_PER_SLOT_INTERRUPT_ENABLE_M (BIT(17))
#define EMAC_AVERAGE_BITS_PER_SLOT_INTERRUPT_ENABLE_V 1
#define EMAC_AVERAGE_BITS_PER_SLOT_INTERRUPT_ENABLE_S 17
#define EMAC_SLOT_COUNT 0x00000007
#define EMAC_SLOT_COUNT_M (EMAC_SLOT_COUNT_V << EMAC_SLOT_COUNT_S)
#define EMAC_SLOT_COUNT_V 0x00000007
#define EMAC_SLOT_COUNT_S 4
#define EMAC_CREDIT_CONTROL (BIT(1))
#define EMAC_CREDIT_CONTROL_M (BIT(1))
#define EMAC_CREDIT_CONTROL_V 1
#define EMAC_CREDIT_CONTROL_S 1
#define EMAC_CREDIT_BASED_SHAPER_DISABLE (BIT(0))
#define EMAC_CREDIT_BASED_SHAPER_DISABLE_M (BIT(0))
#define EMAC_CREDIT_BASED_SHAPER_DISABLE_V 1
#define EMAC_CREDIT_BASED_SHAPER_DISABLE_S 0

#define EMAC_DMACHANNELAVSTS_REG (REG_EMAC_BASE + 0x0064)
#define EMAC_ABS_UPDATED (BIT(17))
#define EMAC_ABS_UPDATED_M (BIT(17))
#define EMAC_ABS_UPDATED_V 1
#define EMAC_ABS_UPDATED_S 17
#define EMAC_AVERAGE_BITS_PER_SLOT 0x0001FFFF
#define EMAC_AVERAGE_BITS_PER_SLOT_M (EMAC_AVERAGE_BITS_PER_SLOT_V << EMAC_AVERAGE_BITS_PER_SLOT_S)
#define EMAC_AVERAGE_BITS_PER_SLOT_V 0x0001FFFF
#define EMAC_AVERAGE_BITS_PER_SLOT_S 0

#define EMAC_DMAIDLESLOPECREDIT_REG (REG_EMAC_BASE + 0x0068)
#define EMAC_IDLESLOPECREDIT 0x00003FFF
#define EMAC_IDLESLOPECREDIT_M (EMAC_IDLESLOPECREDIT_V << EMAC_IDLESLOPECREDIT_S)
#define EMAC_IDLESLOPECREDIT_V 0x00003FFF
#define EMAC_IDLESLOPECREDIT_S 0

#define EMAC_DMASENDSLOPECREDIT_REG (REG_EMAC_BASE + 0x006C)
#define EMAC_SENDSLOPECREDIT 0x00003FFF
#define EMAC_SENDSLOPECREDIT_M (EMAC_SENDSLOPECREDIT_V << EMAC_SENDSLOPECREDIT_S)
#define EMAC_SENDSLOPECREDIT_V 0x00003FFF
#define EMAC_SENDSLOPECREDIT_S 0

#define EMAC_DMAHIGHCREDIT_REG (REG_EMAC_BASE + 0x0070)
#define EMAC_HICREDIT 0x1FFFFFFF
#define EMAC_HICREDIT_M (EMAC_HICREDIT_V << EMAC_HICREDIT_S)
#define EMAC_HICREDIT_V 0x1FFFFFFF
#define EMAC_HICREDIT_S 0

#define EMAC_DMALOCREDIT_REG (REG_EMAC_BASE + 0x0074)
#define EMAC_LOCREDIT 0x1FFFFFFF
#define EMAC_LOCREDIT_M (EMAC_LOCREDIT_V << EMAC_LOCREDIT_S)
#define EMAC_LOCREDIT_V 0x1FFFFFFF
#define EMAC_LOCREDIT_S 0

#define EMAC_GMACCONFIG_REG (REG_EMAC_BASE + 0x1000)
#define EMAC_SOURCE_ADDRESS_INSERTION_REPLACEMENT_CONTROL 0x00000007
#define EMAC_SOURCE_ADDRESS_INSERTION_REPLACEMENT_CONTROL_M (EMAC_SOURCE_ADDRESS_INSERTION_REPLACEMENT_CONTROL_V << EMAC_SOURCE_ADDRESS_INSERTION_REPLACEMENT_CONTROL_S)
#define EMAC_SOURCE_ADDRESS_INSERTION_REPLACEMENT_CONTROL_V 0x00000007
#define EMAC_SOURCE_ADDRESS_INSERTION_REPLACEMENT_CONTROL_S 28
#define EMAC_AS_SUPPORT_2K_PACKETS (BIT(27))
#define EMAC_AS_SUPPORT_2K_PACKETS_M (BIT(27))
#define EMAC_AS_SUPPORT_2K_PACKETS_V 1
#define EMAC_AS_SUPPORT_2K_PACKETS_S 27
#define EMAC_SMII_FORCE_TRANSMIT_ERROR (BIT(26))
#define EMAC_SMII_FORCE_TRANSMIT_ERROR_M (BIT(26))
#define EMAC_SMII_FORCE_TRANSMIT_ERROR_V 1
#define EMAC_SMII_FORCE_TRANSMIT_ERROR_S 26
#define EMAC_CRC_STRIPPING_TYPE_FRAMES (BIT(25))
#define EMAC_CRC_STRIPPING_TYPE_FRAMES_M (BIT(25))
#define EMAC_CRC_STRIPPING_TYPE_FRAMES_V 1
#define EMAC_CRC_STRIPPING_TYPE_FRAMES_S 25
#define EMAC_TRANSMIT_CONFIGURATION (BIT(24))
#define EMAC_TRANSMIT_CONFIGURATION_M (BIT(24))
#define EMAC_TRANSMIT_CONFIGURATION_V 1
#define EMAC_TRANSMIT_CONFIGURATION_S 24
#define EMAC_GMACWATCHDOG (BIT(23))
#define EMAC_GMACWATCHDOG_M (BIT(23))
#define EMAC_GMACWATCHDOG_V 1
#define EMAC_GMACWATCHDOG_S 23
#define EMAC_GMACJABBER (BIT(22))
#define EMAC_GMACJABBER_M (BIT(22))
#define EMAC_GMACJABBER_V 1
#define EMAC_GMACJABBER_S 22
#define EMAC_GMACFRAMEBURST (BIT(21))
#define EMAC_GMACFRAMEBURST_M (BIT(21))
#define EMAC_GMACFRAMEBURST_V 1
#define EMAC_GMACFRAMEBURST_S 21
#define EMAC_GMACJUMBOFRAME (BIT(20))
#define EMAC_GMACJUMBOFRAME_M (BIT(20))
#define EMAC_GMACJUMBOFRAME_V 1
#define EMAC_GMACJUMBOFRAME_S 20
#define EMAC_GMACINTERFRAMEGAP 0x00000007
#define EMAC_GMACINTERFRAMEGAP_M (EMAC_GMACINTERFRAMEGAP_V << EMAC_GMACINTERFRAMEGAP_S)
#define EMAC_GMACINTERFRAMEGAP_V 0x00000007
#define EMAC_GMACINTERFRAMEGAP_S 17
#define EMAC_GMACDISABLECRS (BIT(16))
#define EMAC_GMACDISABLECRS_M (BIT(16))
#define EMAC_GMACDISABLECRS_V 1
#define EMAC_GMACDISABLECRS_S 16
#define EMAC_GMACMIIGMII (BIT(15))
#define EMAC_GMACMIIGMII_M (BIT(15))
#define EMAC_GMACMIIGMII_V 1
#define EMAC_GMACMIIGMII_S 15
#define EMAC_GMACFESPEED (BIT(14))
#define EMAC_GMACFESPEED_M (BIT(14))
#define EMAC_GMACFESPEED_V 1
#define EMAC_GMACFESPEED_S 14
#define EMAC_GMACRXOWN (BIT(13))
#define EMAC_GMACRXOWN_M (BIT(13))
#define EMAC_GMACRXOWN_V 1
#define EMAC_GMACRXOWN_S 13
#define EMAC_GMACLOOPBACK (BIT(12))
#define EMAC_GMACLOOPBACK_M (BIT(12))
#define EMAC_GMACLOOPBACK_V 1
#define EMAC_GMACLOOPBACK_S 12
#define EMAC_GMACDUPLEX (BIT(11))
#define EMAC_GMACDUPLEX_M (BIT(11))
#define EMAC_GMACDUPLEX_V 1
#define EMAC_GMACDUPLEX_S 11
#define EMAC_GMACRXIPCOFFLOAD (BIT(10))
#define EMAC_GMACRXIPCOFFLOAD_M (BIT(10))
#define EMAC_GMACRXIPCOFFLOAD_V 1
#define EMAC_GMACRXIPCOFFLOAD_S 10
#define EMAC_GMACRETRY (BIT(9))
#define EMAC_GMACRETRY_M (BIT(9))
#define EMAC_GMACRETRY_V 1
#define EMAC_GMACRETRY_S 9
#define EMAC_GMACLINK (BIT(8))
#define EMAC_GMACLINK_M (BIT(8))
#define EMAC_GMACLINK_V 1
#define EMAC_GMACLINK_S 8
#define EMAC_GMACPADCRCSTRIP (BIT(7))
#define EMAC_GMACPADCRCSTRIP_M (BIT(7))
#define EMAC_GMACPADCRCSTRIP_V 1
#define EMAC_GMACPADCRCSTRIP_S 7
#define EMAC_GMACBACKOFFLIMIT 0x00000003
#define EMAC_GMACBACKOFFLIMIT_M (EMAC_GMACBACKOFFLIMIT_V << EMAC_GMACBACKOFFLIMIT_S)
#define EMAC_GMACBACKOFFLIMIT_V 0x00000003
#define EMAC_GMACBACKOFFLIMIT_S 5
#define EMAC_GMACDEFERRALCHECK (BIT(4))
#define EMAC_GMACDEFERRALCHECK_M (BIT(4))
#define EMAC_GMACDEFERRALCHECK_V 1
#define EMAC_GMACDEFERRALCHECK_S 4
#define EMAC_GMACTX (BIT(3))
#define EMAC_GMACTX_M (BIT(3))
#define EMAC_GMACTX_V 1
#define EMAC_GMACTX_S 3
#define EMAC_GMACRX (BIT(2))
#define EMAC_GMACRX_M (BIT(2))
#define EMAC_GMACRX_V 1
#define EMAC_GMACRX_S 2
#define EMAC_PREAMBLE_LENGTH_TRANSMIT_FRAMES 0x00000003
#define EMAC_PREAMBLE_LENGTH_TRANSMIT_FRAMES_M (EMAC_PREAMBLE_LENGTH_TRANSMIT_FRAMES_V << EMAC_PREAMBLE_LENGTH_TRANSMIT_FRAMES_S)
#define EMAC_PREAMBLE_LENGTH_TRANSMIT_FRAMES_V 0x00000003
#define EMAC_PREAMBLE_LENGTH_TRANSMIT_FRAMES_S 0

#define EMAC_GMACFRAMEFILTER_REG (REG_EMAC_BASE + 0x1004)
#define EMAC_RECEIVEALL (BIT(31))
#define EMAC_RECEIVEALL_M (BIT(31))
#define EMAC_RECEIVEALL_V 1
#define EMAC_RECEIVEALL_S 31
#define EMAC_DROP_NON_TCP_UDP_IP_FRAMES (BIT(21))
#define EMAC_DROP_NON_TCP_UDP_IP_FRAMES_M (BIT(21))
#define EMAC_DROP_NON_TCP_UDP_IP_FRAMES_V 1
#define EMAC_DROP_NON_TCP_UDP_IP_FRAMES_S 21
#define EMAC_LAYER_3_AND_LAYER_4_FILTER_ENABLE (BIT(20))
#define EMAC_LAYER_3_AND_LAYER_4_FILTER_ENABLE_M (BIT(20))
#define EMAC_LAYER_3_AND_LAYER_4_FILTER_ENABLE_V 1
#define EMAC_LAYER_3_AND_LAYER_4_FILTER_ENABLE_S 20
#define EMAC_VLAN_TAG_FILTER_ENABLE (BIT(16))
#define EMAC_VLAN_TAG_FILTER_ENABLE_M (BIT(16))
#define EMAC_VLAN_TAG_FILTER_ENABLE_V 1
#define EMAC_VLAN_TAG_FILTER_ENABLE_S 16
#define EMAC_HASH_OR_PERFECT_FILTE (BIT(10))
#define EMAC_HASH_OR_PERFECT_FILTE_M (BIT(10))
#define EMAC_HASH_OR_PERFECT_FILTE_V 1
#define EMAC_HASH_OR_PERFECT_FILTE_S 10
#define EMAC_SOURCE_ADDRESS_FILTER_ENABLE (BIT(9))
#define EMAC_SOURCE_ADDRESS_FILTER_ENABLE_M (BIT(9))
#define EMAC_SOURCE_ADDRESS_FILTER_ENABLE_V 1
#define EMAC_SOURCE_ADDRESS_FILTER_ENABLE_S 9
#define EMAC_SA_INVERSE_FILTERING (BIT(8))
#define EMAC_SA_INVERSE_FILTERING_M (BIT(8))
#define EMAC_SA_INVERSE_FILTERING_V 1
#define EMAC_SA_INVERSE_FILTERING_S 8
#define EMAC_PASS_CONTROL_FRAMES 0x00000003
#define EMAC_PASS_CONTROL_FRAMES_M (EMAC_PASS_CONTROL_FRAMES_V << EMAC_PASS_CONTROL_FRAMES_S)
#define EMAC_PASS_CONTROL_FRAMES_V 0x00000003
#define EMAC_PASS_CONTROL_FRAMES_S 6
#define EMAC_DISABLE_BROADCAST_FRAMES (BIT(5))
#define EMAC_DISABLE_BROADCAST_FRAMES_M (BIT(5))
#define EMAC_DISABLE_BROADCAST_FRAMES_V 1
#define EMAC_DISABLE_BROADCAST_FRAMES_S 5
#define EMAC_PASS_ALL_MULTICAST (BIT(4))
#define EMAC_PASS_ALL_MULTICAST_M (BIT(4))
#define EMAC_PASS_ALL_MULTICAST_V 1
#define EMAC_PASS_ALL_MULTICAST_S 4
#define EMAC_DA_INVERSE_FILTERING (BIT(3))
#define EMAC_DA_INVERSE_FILTERING_M (BIT(3))
#define EMAC_DA_INVERSE_FILTERING_V 1
#define EMAC_DA_INVERSE_FILTERING_S 3
#define EMAC_HASH_MULTICAST (BIT(2))
#define EMAC_HASH_MULTICAST_M (BIT(2))
#define EMAC_HASH_MULTICAST_V 1
#define EMAC_HASH_MULTICAST_S 2
#define EMAC_HASH_UNICAST (BIT(1))
#define EMAC_HASH_UNICAST_M (BIT(1))
#define EMAC_HASH_UNICAST_V 1
#define EMAC_HASH_UNICAST_S 1
#define EMAC_PROMISCUOUS_MODE (BIT(0))
#define EMAC_PROMISCUOUS_MODE_M (BIT(0))
#define EMAC_PROMISCUOUS_MODE_V 1
#define EMAC_PROMISCUOUS_MODE_S 0

#define EMAC_GMACHASHHIGH_REG (REG_EMAC_BASE + 0x1008)
#define EMAC_HASH_TABLE_HIGH 0xFFFFFFFF
#define EMAC_HASH_TABLE_HIGH_M (EMAC_HASH_TABLE_HIGH_V << EMAC_HASH_TABLE_HIGH_S)
#define EMAC_HASH_TABLE_HIGH_V 0xFFFFFFFF
#define EMAC_HASH_TABLE_HIGH_S 0

#define EMAC_GMACHASHLOW_REG (REG_EMAC_BASE + 0x100C)
#define EMAC_HASH_TABLE_LOW 0xFFFFFFFF
#define EMAC_HASH_TABLE_LOW_M (EMAC_HASH_TABLE_LOW_V << EMAC_HASH_TABLE_LOW_S)
#define EMAC_HASH_TABLE_LOW_V 0xFFFFFFFF
#define EMAC_HASH_TABLE_LOW_S 0

#define EMAC_GMACGMIIADDR_REG (REG_EMAC_BASE + 0x1010)
#define EMAC_GMIIDEV 0x0000001F
#define EMAC_GMIIDEV_M (EMAC_GMIIDEV_V << EMAC_GMIIDEV_S)
#define EMAC_GMIIDEV_V 0x0000001F
#define EMAC_GMIIDEV_S 11
#define EMAC_GMIIREG 0x0000001F
#define EMAC_GMIIREG_M (EMAC_GMIIREG_V << EMAC_GMIIREG_S)
#define EMAC_GMIIREG_V 0x0000001F
#define EMAC_GMIIREG_S 6
#define EMAC_GMIICSRCLK 0x0000000F
#define EMAC_GMIICSRCLK_M (EMAC_GMIICSRCLK_V << EMAC_GMIICSRCLK_S)
#define EMAC_GMIICSRCLK_V 0x0000000F
#define EMAC_GMIICSRCLK_S 2
#define EMAC_GMIIWRITE (BIT(1))
#define EMAC_GMIIWRITE_M (BIT(1))
#define EMAC_GMIIWRITE_V 1
#define EMAC_GMIIWRITE_S 1
#define EMAC_GMIIBUSY (BIT(0))
#define EMAC_GMIIBUSY_M (BIT(0))
#define EMAC_GMIIBUSY_V 1
#define EMAC_GMIIBUSY_S 0

#define EMAC_GMACGMIIDATA_REG (REG_EMAC_BASE + 0x1014)
#define EMAC_GMII_DATA 0x0000FFFF
#define EMAC_GMII_DATA_M (EMAC_GMII_DATA_V << EMAC_GMII_DATA_S)
#define EMAC_GMII_DATA_V 0x0000FFFF
#define EMAC_GMII_DATA_S 0

#define EMAC_GMACFLOWCONTROL_REG (REG_EMAC_BASE + 0x1018)
#define EMAC_PAUSE_TIME 0x0000FFFF
#define EMAC_PAUSE_TIME_M (EMAC_PAUSE_TIME_V << EMAC_PAUSE_TIME_S)
#define EMAC_PAUSE_TIME_V 0x0000FFFF
#define EMAC_PAUSE_TIME_S 16
#define EMAC_DISABLE_ZERO_QUANTA_PAUSE (BIT(7))
#define EMAC_DISABLE_ZERO_QUANTA_PAUSE_M (BIT(7))
#define EMAC_DISABLE_ZERO_QUANTA_PAUSE_V 1
#define EMAC_DISABLE_ZERO_QUANTA_PAUSE_S 7
#define EMAC_PAUSE_LOW_THRESHOLD 0x00000003
#define EMAC_PAUSE_LOW_THRESHOLD_M (EMAC_PAUSE_LOW_THRESHOLD_V << EMAC_PAUSE_LOW_THRESHOLD_S)
#define EMAC_PAUSE_LOW_THRESHOLD_V 0x00000003
#define EMAC_PAUSE_LOW_THRESHOLD_S 4
#define EMAC_UNICAST_PAUSE_FRAME_DETECT (BIT(3))
#define EMAC_UNICAST_PAUSE_FRAME_DETECT_M (BIT(3))
#define EMAC_UNICAST_PAUSE_FRAME_DETECT_V 1
#define EMAC_UNICAST_PAUSE_FRAME_DETECT_S 3
#define EMAC_RECEIVE_FLOW_CONTROL_ENABLE (BIT(2))
#define EMAC_RECEIVE_FLOW_CONTROL_ENABLE_M (BIT(2))
#define EMAC_RECEIVE_FLOW_CONTROL_ENABLE_V 1
#define EMAC_RECEIVE_FLOW_CONTROL_ENABLE_S 2
#define EMAC_TRANSMIT_FLOW_CONTROL_ENABLE (BIT(1))
#define EMAC_TRANSMIT_FLOW_CONTROL_ENABLE_M (BIT(1))
#define EMAC_TRANSMIT_FLOW_CONTROL_ENABLE_V 1
#define EMAC_TRANSMIT_FLOW_CONTROL_ENABLE_S 1
#define EMAC_FLOW_CONTROL_BUSY_BACKPRESSURE_ACTIVATE (BIT(0))
#define EMAC_FLOW_CONTROL_BUSY_BACKPRESSURE_ACTIVATE_M (BIT(0))
#define EMAC_FLOW_CONTROL_BUSY_BACKPRESSURE_ACTIVATE_V 1
#define EMAC_FLOW_CONTROL_BUSY_BACKPRESSURE_ACTIVATE_S 0

#define EMAC_GMACVLAN_REG (REG_EMAC_BASE + 0x101C)
#define EMAC_VLAN_TAG_HASH_TABLE_MATCH_ENABLE (BIT(19))
#define EMAC_VLAN_TAG_HASH_TABLE_MATCH_ENABLE_M (BIT(19))
#define EMAC_VLAN_TAG_HASH_TABLE_MATCH_ENABLE_V 1
#define EMAC_VLAN_TAG_HASH_TABLE_MATCH_ENABLE_S 19
#define EMAC_ENABLE_S_VLAN (BIT(18))
#define EMAC_ENABLE_S_VLAN_M (BIT(18))
#define EMAC_ENABLE_S_VLAN_V 1
#define EMAC_ENABLE_S_VLAN_S 18
#define EMAC_VLAN_TAG_INVERSE_MATCH_ENABLE (BIT(17))
#define EMAC_VLAN_TAG_INVERSE_MATCH_ENABLE_M (BIT(17))
#define EMAC_VLAN_TAG_INVERSE_MATCH_ENABLE_V 1
#define EMAC_VLAN_TAG_INVERSE_MATCH_ENABLE_S 17
#define EMAC_ENABLE_VLAN_TAG_COMPARISON (BIT(16))
#define EMAC_ENABLE_VLAN_TAG_COMPARISON_M (BIT(16))
#define EMAC_ENABLE_VLAN_TAG_COMPARISON_V 1
#define EMAC_ENABLE_VLAN_TAG_COMPARISON_S 16
#define EMAC_VLAN_TAG_IDENTIFIER_RECEIVE_FRAMES 0x0000FFFF
#define EMAC_VLAN_TAG_IDENTIFIER_RECEIVE_FRAMES_M (EMAC_VLAN_TAG_IDENTIFIER_RECEIVE_FRAMES_V << EMAC_VLAN_TAG_IDENTIFIER_RECEIVE_FRAMES_S)
#define EMAC_VLAN_TAG_IDENTIFIER_RECEIVE_FRAMES_V 0x0000FFFF
#define EMAC_VLAN_TAG_IDENTIFIER_RECEIVE_FRAMES_S 0

#define EMAC_GMACVERSION_REG (REG_EMAC_BASE + 0x1020)
#define EMAC_USERVER 0x000000FF
#define EMAC_USERVER_M (EMAC_USERVER_V << EMAC_USERVER_S)
#define EMAC_USERVER_V 0x000000FF
#define EMAC_USERVER_S 8
#define EMAC_SNPSVER 0x000000FF
#define EMAC_SNPSVER_M (EMAC_SNPSVER_V << EMAC_SNPSVER_S)
#define EMAC_SNPSVER_V 0x000000FF
#define EMAC_SNPSVER_S 0

#define EMAC_GMACDEBUG_REG (REG_EMAC_BASE + 0x1024)
#define EMAC_MTL_TXSTATUS_FIFO_FULL_STATUS (BIT(25))
#define EMAC_MTL_TXSTATUS_FIFO_FULL_STATUS_M (BIT(25))
#define EMAC_MTL_TXSTATUS_FIFO_FULL_STATUS_V 1
#define EMAC_MTL_TXSTATUS_FIFO_FULL_STATUS_S 25
#define EMAC_MTL_TX_FIFO_NOT_EMPTY_STATUS (BIT(24))
#define EMAC_MTL_TX_FIFO_NOT_EMPTY_STATUS_M (BIT(24))
#define EMAC_MTL_TX_FIFO_NOT_EMPTY_STATUS_V 1
#define EMAC_MTL_TX_FIFO_NOT_EMPTY_STATUS_S 24
#define EMAC_MTL_TX_FIFO_WRITE_CONTROLLER_STATUS (BIT(22))
#define EMAC_MTL_TX_FIFO_WRITE_CONTROLLER_STATUS_M (BIT(22))
#define EMAC_MTL_TX_FIFO_WRITE_CONTROLLER_STATUS_V 1
#define EMAC_MTL_TX_FIFO_WRITE_CONTROLLER_STATUS_S 22
#define EMAC_MTL_TX_FIFO_READ_CONTROLLER_STATUS 0x00000003
#define EMAC_MTL_TX_FIFO_READ_CONTROLLER_STATUS_M (EMAC_MTL_TX_FIFO_READ_CONTROLLER_STATUS_V << EMAC_MTL_TX_FIFO_READ_CONTROLLER_STATUS_S)
#define EMAC_MTL_TX_FIFO_READ_CONTROLLER_STATUS_V 0x00000003
#define EMAC_MTL_TX_FIFO_READ_CONTROLLER_STATUS_S 20
#define EMAC_MAC_TRANSMITTER_PAUSE (BIT(19))
#define EMAC_MAC_TRANSMITTER_PAUSE_M (BIT(19))
#define EMAC_MAC_TRANSMITTER_PAUSE_V 1
#define EMAC_MAC_TRANSMITTER_PAUSE_S 19
#define EMAC_MAC_TRANSMIT_FRAME_CONTROLLER_STATUS 0x00000003
#define EMAC_MAC_TRANSMIT_FRAME_CONTROLLER_STATUS_M (EMAC_MAC_TRANSMIT_FRAME_CONTROLLER_STATUS_V << EMAC_MAC_TRANSMIT_FRAME_CONTROLLER_STATUS_S)
#define EMAC_MAC_TRANSMIT_FRAME_CONTROLLER_STATUS_V 0x00000003
#define EMAC_MAC_TRANSMIT_FRAME_CONTROLLER_STATUS_S 17
#define EMAC_MAC_TRANSMIT_PROTOCOL_ENGINE_STATUS (BIT(16))
#define EMAC_MAC_TRANSMIT_PROTOCOL_ENGINE_STATUS_M (BIT(16))
#define EMAC_MAC_TRANSMIT_PROTOCOL_ENGINE_STATUS_V 1
#define EMAC_MAC_TRANSMIT_PROTOCOL_ENGINE_STATUS_S 16
#define EMAC_MTL_RXFIFO_FILL_LEVEL_STATUS 0x00000003
#define EMAC_MTL_RXFIFO_FILL_LEVEL_STATUS_M (EMAC_MTL_RXFIFO_FILL_LEVEL_STATUS_V << EMAC_MTL_RXFIFO_FILL_LEVEL_STATUS_S)
#define EMAC_MTL_RXFIFO_FILL_LEVEL_STATUS_V 0x00000003
#define EMAC_MTL_RXFIFO_FILL_LEVEL_STATUS_S 8
#define EMAC_MTL_RXFIFO_READ_CONTROLLER_STATE 0x00000003
#define EMAC_MTL_RXFIFO_READ_CONTROLLER_STATE_M (EMAC_MTL_RXFIFO_READ_CONTROLLER_STATE_V << EMAC_MTL_RXFIFO_READ_CONTROLLER_STATE_S)
#define EMAC_MTL_RXFIFO_READ_CONTROLLER_STATE_V 0x00000003
#define EMAC_MTL_RXFIFO_READ_CONTROLLER_STATE_S 5
#define EMAC_MTL_RX_FIFO_WRITE_CONTROLLER_ACTIVE_STATUS (BIT(4))
#define EMAC_MTL_RX_FIFO_WRITE_CONTROLLER_ACTIVE_STATUS_M (BIT(4))
#define EMAC_MTL_RX_FIFO_WRITE_CONTROLLER_ACTIVE_STATUS_V 1
#define EMAC_MTL_RX_FIFO_WRITE_CONTROLLER_ACTIVE_STATUS_S 4
#define EMAC_MAC_RECEIVE_FRAME_FIFO_CONTROLLER_STATUS 0x00000003
#define EMAC_MAC_RECEIVE_FRAME_FIFO_CONTROLLER_STATUS_M (EMAC_MAC_RECEIVE_FRAME_FIFO_CONTROLLER_STATUS_V << EMAC_MAC_RECEIVE_FRAME_FIFO_CONTROLLER_STATUS_S)
#define EMAC_MAC_RECEIVE_FRAME_FIFO_CONTROLLER_STATUS_V 0x00000003
#define EMAC_MAC_RECEIVE_FRAME_FIFO_CONTROLLER_STATUS_S 1
#define EMAC_MAC_RECEIVE_PROTOCOL_ENGINE_STATUS (BIT(0))
#define EMAC_MAC_RECEIVE_PROTOCOL_ENGINE_STATUS_M (BIT(0))
#define EMAC_MAC_RECEIVE_PROTOCOL_ENGINE_STATUS_V 1
#define EMAC_MAC_RECEIVE_PROTOCOL_ENGINE_STATUS_S 0

#define EMAC_GMACLPITIMERSCONTROL_REG (REG_EMAC_BASE + 0x1034)
#define EMAC_LPI_LS_TIMER 0x000003FF
#define EMAC_LPI_LS_TIMER_M (EMAC_LPI_LS_TIMER_V << EMAC_LPI_LS_TIMER_S)
#define EMAC_LPI_LS_TIMER_V 0x000003FF
#define EMAC_LPI_LS_TIMER_S 16
#define EMAC_LPI_TW_TIMER 0x0000FFFF
#define EMAC_LPI_TW_TIMER_M (EMAC_LPI_TW_TIMER_V << EMAC_LPI_TW_TIMER_S)
#define EMAC_LPI_TW_TIMER_V 0x0000FFFF
#define EMAC_LPI_TW_TIMER_S 0

#define EMAC_GMACINTERRUPTSTATUS_REG (REG_EMAC_BASE + 0x1038)
#define EMAC_GPI_INTERRUPT_STATUS (BIT(11))
#define EMAC_GPI_INTERRUPT_STATUS_M (BIT(11))
#define EMAC_GPI_INTERRUPT_STATUS_V 1
#define EMAC_GPI_INTERRUPT_STATUS_S 11
#define EMAC_LPI_INTERRUPT_STATUS (BIT(10))
#define EMAC_LPI_INTERRUPT_STATUS_M (BIT(10))
#define EMAC_LPI_INTERRUPT_STATUS_V 1
#define EMAC_LPI_INTERRUPT_STATUS_S 10
#define EMAC_TIMESTAMP_INTERRUP_STATUS (BIT(9))
#define EMAC_TIMESTAMP_INTERRUP_STATUS_M (BIT(9))
#define EMAC_TIMESTAMP_INTERRUP_STATUS_V 1
#define EMAC_TIMESTAMP_INTERRUP_STATUS_S 9
#define EMAC_MMC_RECEIVE_CHECKSUM_OFFLOAD_INTERRUPT_STATUS (BIT(7))
#define EMAC_MMC_RECEIVE_CHECKSUM_OFFLOAD_INTERRUPT_STATUS_M (BIT(7))
#define EMAC_MMC_RECEIVE_CHECKSUM_OFFLOAD_INTERRUPT_STATUS_V 1
#define EMAC_MMC_RECEIVE_CHECKSUM_OFFLOAD_INTERRUPT_STATUS_S 7
#define EMAC_MMC_TRANSMIT_INTERRUPT_STATUS (BIT(6))
#define EMAC_MMC_TRANSMIT_INTERRUPT_STATUS_M (BIT(6))
#define EMAC_MMC_TRANSMIT_INTERRUPT_STATUS_V 1
#define EMAC_MMC_TRANSMIT_INTERRUPT_STATUS_S 6
#define EMAC_MMC_RECEIVE_INTERRUPT_STATUS (BIT(5))
#define EMAC_MMC_RECEIVE_INTERRUPT_STATUS_M (BIT(5))
#define EMAC_MMC_RECEIVE_INTERRUPT_STATUS_V 1
#define EMAC_MMC_RECEIVE_INTERRUPT_STATUS_S 5
#define EMAC_MMC_INTERRUPT_STATUS (BIT(4))
#define EMAC_MMC_INTERRUPT_STATUS_M (BIT(4))
#define EMAC_MMC_INTERRUPT_STATUS_V 1
#define EMAC_MMC_INTERRUPT_STATUS_S 4
#define EMAC_PMT_INTERRUPT_STATUS (BIT(3))
#define EMAC_PMT_INTERRUPT_STATUS_M (BIT(3))
#define EMAC_PMT_INTERRUPT_STATUS_V 1
#define EMAC_PMT_INTERRUPT_STATUS_S 3
#define EMAC_PCS_AUTO_NEGOTIATION_COMPLETE (BIT(2))
#define EMAC_PCS_AUTO_NEGOTIATION_COMPLETE_M (BIT(2))
#define EMAC_PCS_AUTO_NEGOTIATION_COMPLETE_V 1
#define EMAC_PCS_AUTO_NEGOTIATION_COMPLETE_S 2
#define EMAC_PCS_LINK_STATUS_CHANGED (BIT(1))
#define EMAC_PCS_LINK_STATUS_CHANGED_M (BIT(1))
#define EMAC_PCS_LINK_STATUS_CHANGED_V 1
#define EMAC_PCS_LINK_STATUS_CHANGED_S 1
#define EMAC_INTERRUPT_STATUS (BIT(0))
#define EMAC_INTERRUPT_STATUS_M (BIT(0))
#define EMAC_INTERRUPT_STATUS_V 1
#define EMAC_INTERRUPT_STATUS_S 0

#define EMAC_GMACINTERRUPTMASK_REG (REG_EMAC_BASE + 0x103C)
#define EMAC_LPI_INTERRUPT_MASK (BIT(10))
#define EMAC_LPI_INTERRUPT_MASK_M (BIT(10))
#define EMAC_LPI_INTERRUPT_MASK_V 1
#define EMAC_LPI_INTERRUPT_MASK_S 10
#define EMAC_TIMESTAMP_INTERRUPT_MASK (BIT(9))
#define EMAC_TIMESTAMP_INTERRUPT_MASK_M (BIT(9))
#define EMAC_TIMESTAMP_INTERRUPT_MASK_V 1
#define EMAC_TIMESTAMP_INTERRUPT_MASK_S 9
#define EMAC_PMT_INTERRUPT_MASK (BIT(3))
#define EMAC_PMT_INTERRUPT_MASK_M (BIT(3))
#define EMAC_PMT_INTERRUPT_MASK_V 1
#define EMAC_PMT_INTERRUPT_MASK_S 3
#define EMAC_PCS_AN_COMPLETION_INTERRUPT_MASK (BIT(2))
#define EMAC_PCS_AN_COMPLETION_INTERRUPT_MASK_M (BIT(2))
#define EMAC_PCS_AN_COMPLETION_INTERRUPT_MASK_V 1
#define EMAC_PCS_AN_COMPLETION_INTERRUPT_MASK_S 2
#define EMAC_PCS_LINK_STATUS_INTERRUPT_MASK (BIT(1))
#define EMAC_PCS_LINK_STATUS_INTERRUPT_MASK_M (BIT(1))
#define EMAC_PCS_LINK_STATUS_INTERRUPT_MASK_V 1
#define EMAC_PCS_LINK_STATUS_INTERRUPT_MASK_S 1
#define EMAC_INTERRUPT_MASK (BIT(0))
#define EMAC_INTERRUPT_MASK_M (BIT(0))
#define EMAC_INTERRUPT_MASK_V 1
#define EMAC_INTERRUPT_MASK_S 0

#define EMAC_GMACADDR0HIGH_REG (REG_EMAC_BASE + 0x1040)
#define EMAC_ADDRESS_ENABLE0 (BIT(31))
#define EMAC_ADDRESS_ENABLE0_M (BIT(31))
#define EMAC_ADDRESS_ENABLE0_V 1
#define EMAC_ADDRESS_ENABLE0_S 31
#define EMAC_MAC_ADDRESS0_HI 0x0000FFFF
#define EMAC_MAC_ADDRESS0_HI_M (EMAC_MAC_ADDRESS0_HI_V << EMAC_MAC_ADDRESS0_HI_S)
#define EMAC_MAC_ADDRESS0_HI_V 0x0000FFFF
#define EMAC_MAC_ADDRESS0_HI_S 0

#define EMAC_GMACADDR0LOW_REG (REG_EMAC_BASE + 0x1044)
#define EMAC_MAC_ADDRESS0_LOW 0xFFFFFFFF
#define EMAC_MAC_ADDRESS0_LOW_M (EMAC_MAC_ADDRESS0_LOW_V << EMAC_MAC_ADDRESS0_LOW_S)
#define EMAC_MAC_ADDRESS0_LOW_V 0xFFFFFFFF
#define EMAC_MAC_ADDRESS0_LOW_S 0

#define EMAC_GMACADDR1HIGH_REG (REG_EMAC_BASE + 0x1048)
#define EMAC_ADDRESS_ENABLE1 (BIT(31))
#define EMAC_ADDRESS_ENABLE1_M (BIT(31))
#define EMAC_ADDRESS_ENABLE1_V 1
#define EMAC_ADDRESS_ENABLE1_S 31
#define EMAC_SOURCE_ADDRESS (BIT(30))
#define EMAC_SOURCE_ADDRESS_M (BIT(30))
#define EMAC_SOURCE_ADDRESS_V 1
#define EMAC_SOURCE_ADDRESS_S 30
#define EMAC_MASK_BYTE_CONTROL 0x0000003F
#define EMAC_MASK_BYTE_CONTROL_M (EMAC_MASK_BYTE_CONTROL_V << EMAC_MASK_BYTE_CONTROL_S)
#define EMAC_MASK_BYTE_CONTROL_V 0x0000003F
#define EMAC_MASK_BYTE_CONTROL_S 24
#define EMAC_MAC_ADDRESS1_HI 0x0000FFFF
#define EMAC_MAC_ADDRESS1_HI_M (EMAC_MAC_ADDRESS1_HI_V << EMAC_MAC_ADDRESS1_HI_S)
#define EMAC_MAC_ADDRESS1_HI_V 0x0000FFFF
#define EMAC_MAC_ADDRESS1_HI_S 0

#define EMAC_GMACADDR1LOW_REG (REG_EMAC_BASE + 0x104C)
#define EMAC_MAC_ADDRESS1_LOW 0xFFFFFFFF
#define EMAC_MAC_ADDRESS1_LOW_M (EMAC_MAC_ADDRESS1_LOW_V << EMAC_MAC_ADDRESS1_LOW_S)
#define EMAC_MAC_ADDRESS1_LOW_V 0xFFFFFFFF
#define EMAC_MAC_ADDRESS1_LOW_S 0

#define EMAC_GMAC_AN_CONTROL_REG (REG_EMAC_BASE + 0x10C0)
#define EMAC_SGMII_RAL_CONTROL (BIT(18))
#define EMAC_SGMII_RAL_CONTROL_M (BIT(18))
#define EMAC_SGMII_RAL_CONTROL_V 1
#define EMAC_SGMII_RAL_CONTROL_S 18
#define EMAC_LOCK_REFERENCE (BIT(17))
#define EMAC_LOCK_REFERENCE_M (BIT(17))
#define EMAC_LOCK_REFERENCE_V 1
#define EMAC_LOCK_REFERENCE_S 17
#define EMAC_ENABLE_COMMA_DETECT (BIT(16))
#define EMAC_ENABLE_COMMA_DETECT_M (BIT(16))
#define EMAC_ENABLE_COMMA_DETECT_V 1
#define EMAC_ENABLE_COMMA_DETECT_S 16
#define EMAC_EXTERNAL_LOOPBACK_ENABLE (BIT(14))
#define EMAC_EXTERNAL_LOOPBACK_ENABLE_M (BIT(14))
#define EMAC_EXTERNAL_LOOPBACK_ENABLE_V 1
#define EMAC_EXTERNAL_LOOPBACK_ENABLE_S 14
#define EMAC_AUTO_NEGOTIATION_ENABLE (BIT(12))
#define EMAC_AUTO_NEGOTIATION_ENABLE_M (BIT(12))
#define EMAC_AUTO_NEGOTIATION_ENABLE_V 1
#define EMAC_AUTO_NEGOTIATION_ENABLE_S 12
#define EMAC_RESTART_AUTO_NEGOTIATION (BIT(9))
#define EMAC_RESTART_AUTO_NEGOTIATION_M (BIT(9))
#define EMAC_RESTART_AUTO_NEGOTIATION_V 1
#define EMAC_RESTART_AUTO_NEGOTIATION_S 9

#define EMAC_GMAC_AN_STATUS_REG (REG_EMAC_BASE + 0x10C4)
#define EMAC_EXTENDED_STATUS (BIT(8))
#define EMAC_EXTENDED_STATUS_M (BIT(8))
#define EMAC_EXTENDED_STATUS_V 1
#define EMAC_EXTENDED_STATUS_S 8
#define EMAC_AUTO_NEGOTIATION_COMPLETE (BIT(5))
#define EMAC_AUTO_NEGOTIATION_COMPLETE_M (BIT(5))
#define EMAC_AUTO_NEGOTIATION_COMPLETE_V 1
#define EMAC_AUTO_NEGOTIATION_COMPLETE_S 5
#define EMAC_AUTO_NEGOTIATION_ABILITY (BIT(3))
#define EMAC_AUTO_NEGOTIATION_ABILITY_M (BIT(3))
#define EMAC_AUTO_NEGOTIATION_ABILITY_V 1
#define EMAC_AUTO_NEGOTIATION_ABILITY_S 3
#define EMAC_LINK_AN_STATUS (BIT(2))
#define EMAC_LINK_AN_STATUS_M (BIT(2))
#define EMAC_LINK_AN_STATUS_V 1
#define EMAC_LINK_AN_STATUS_S 2

#define EMAC_GMAC_AUTO_NEGOTIATION_ADVERTISEMENT_REG (REG_EMAC_BASE + 0x10C8)
#define EMAC_ADV_NEXT_PAGE_SUPPORT (BIT(15))
#define EMAC_ADV_NEXT_PAGE_SUPPORT_M (BIT(15))
#define EMAC_ADV_NEXT_PAGE_SUPPORT_V 1
#define EMAC_ADV_NEXT_PAGE_SUPPORT_S 15
#define EMAC_ADV_REMOTE_FAULT_ENCODING 0x00000003
#define EMAC_ADV_REMOTE_FAULT_ENCODING_M (EMAC_ADV_REMOTE_FAULT_ENCODING_V << EMAC_ADV_REMOTE_FAULT_ENCODING_S)
#define EMAC_ADV_REMOTE_FAULT_ENCODING_V 0x00000003
#define EMAC_ADV_REMOTE_FAULT_ENCODING_S 12
#define EMAC_ADV_PAUSE_ENCODING 0x00000003
#define EMAC_ADV_PAUSE_ENCODING_M (EMAC_ADV_PAUSE_ENCODING_V << EMAC_ADV_PAUSE_ENCODING_S)
#define EMAC_ADV_PAUSE_ENCODING_V 0x00000003
#define EMAC_ADV_PAUSE_ENCODING_S 7
#define EMAC_ADV_HALF_DUPLEX (BIT(6))
#define EMAC_ADV_HALF_DUPLEX_M (BIT(6))
#define EMAC_ADV_HALF_DUPLEX_V 1
#define EMAC_ADV_HALF_DUPLEX_S 6
#define EMAC_ADV_FULL_DUPLEX (BIT(5))
#define EMAC_ADV_FULL_DUPLEX_M (BIT(5))
#define EMAC_ADV_FULL_DUPLEX_V 1
#define EMAC_ADV_FULL_DUPLEX_S 5

#define EMAC_GMAC_AUTO_NEGOTIATION_LINK_PARTNER_ABILITY_REG (REG_EMAC_BASE + 0x10CC)
#define EMAC_LINK_NEXT_PAGE_SUPPORT (BIT(15))
#define EMAC_LINK_NEXT_PAGE_SUPPORT_M (BIT(15))
#define EMAC_LINK_NEXT_PAGE_SUPPORT_V 1
#define EMAC_LINK_NEXT_PAGE_SUPPORT_S 15
#define EMAC_LINK_ACKNOWLEDGE (BIT(14))
#define EMAC_LINK_ACKNOWLEDGE_M (BIT(14))
#define EMAC_LINK_ACKNOWLEDGE_V 1
#define EMAC_LINK_ACKNOWLEDGE_S 14
#define EMAC_LINK_REMOTE_FAULT_ENCODING 0x00000003
#define EMAC_LINK_REMOTE_FAULT_ENCODING_M (EMAC_LINK_REMOTE_FAULT_ENCODING_V << EMAC_LINK_REMOTE_FAULT_ENCODING_S)
#define EMAC_LINK_REMOTE_FAULT_ENCODING_V 0x00000003
#define EMAC_LINK_REMOTE_FAULT_ENCODING_S 12
#define EMAC_LINK_PAUSE_ENCODING 0x00000003
#define EMAC_LINK_PAUSE_ENCODING_M (EMAC_LINK_PAUSE_ENCODING_V << EMAC_LINK_PAUSE_ENCODING_S)
#define EMAC_LINK_PAUSE_ENCODING_V 0x00000003
#define EMAC_LINK_PAUSE_ENCODING_S 7
#define EMAC_LINK_HALF_DUPLEX (BIT(6))
#define EMAC_LINK_HALF_DUPLEX_M (BIT(6))
#define EMAC_LINK_HALF_DUPLEX_V 1
#define EMAC_LINK_HALF_DUPLEX_S 6
#define EMAC_LINK_FULL_DUPLEX (BIT(5))
#define EMAC_LINK_FULL_DUPLEX_M (BIT(5))
#define EMAC_LINK_FULL_DUPLEX_V 1
#define EMAC_LINK_FULL_DUPLEX_S 5

#define EMAC_GMAC_AUTO_NEGOTIATION_EXPANSION_REG (REG_EMAC_BASE + 0x10D0)
#define EMAC_NEXT_PAGE_ABILITY (BIT(2))
#define EMAC_NEXT_PAGE_ABILITY_M (BIT(2))
#define EMAC_NEXT_PAGE_ABILITY_V 1
#define EMAC_NEXT_PAGE_ABILITY_S 2
#define EMAC_NEW_PAGE_RECEIVED (BIT(1))
#define EMAC_NEW_PAGE_RECEIVED_M (BIT(1))
#define EMAC_NEW_PAGE_RECEIVED_V 1
#define EMAC_NEW_PAGE_RECEIVED_S 1

#define EMAC_GMAC_TBI_EXTENDED_STATUS_REG (REG_EMAC_BASE + 0x10D4)
#define EMAC_1000BASE_X_FULL_DUPLEX_CAPABLE (BIT(15))
#define EMAC_1000BASE_X_FULL_DUPLEX_CAPABLE_M (BIT(15))
#define EMAC_1000BASE_X_FULL_DUPLEX_CAPABLE_V 1
#define EMAC_1000BASE_X_FULL_DUPLEX_CAPABLE_S 15
#define EMAC_1000BASE_X_HALF_DUPLEX_CAPABLE (BIT(14))
#define EMAC_1000BASE_X_HALF_DUPLEX_CAPABLE_M (BIT(14))
#define EMAC_1000BASE_X_HALF_DUPLEX_CAPABLE_V 1
#define EMAC_1000BASE_X_HALF_DUPLEX_CAPABLE_S 14

#define EMAC_GMAC_CONTROL_STATUS_REG (REG_EMAC_BASE + 0x10D8)
#define EMAC_SMIDRXS (BIT(16))
#define EMAC_SMIDRXS_M (BIT(16))
#define EMAC_SMIDRXS_V 1
#define EMAC_SMIDRXS_S 16
#define EMAC_FALSE_CARRIER_DETECTED (BIT(5))
#define EMAC_FALSE_CARRIER_DETECTED_M (BIT(5))
#define EMAC_FALSE_CARRIER_DETECTED_V 1
#define EMAC_FALSE_CARRIER_DETECTED_S 5
#define EMAC_JABBER_TIMEOUT (BIT(4))
#define EMAC_JABBER_TIMEOUT_M (BIT(4))
#define EMAC_JABBER_TIMEOUT_V 1
#define EMAC_JABBER_TIMEOUT_S 4
#define EMAC_LINK_STATUS (BIT(3))
#define EMAC_LINK_STATUS_M (BIT(3))
#define EMAC_LINK_STATUS_V 1
#define EMAC_LINK_STATUS_S 3
#define EMAC_LINK_SPEED 0x00000003
#define EMAC_LINK_SPEED_M (EMAC_LINK_SPEED_V << EMAC_LINK_SPEED_S)
#define EMAC_LINK_SPEED_V 0x00000003
#define EMAC_LINK_SPEED_S 1
#define EMAC_LINK_MODE (BIT(0))
#define EMAC_LINK_MODE_M (BIT(0))
#define EMAC_LINK_MODE_V 1
#define EMAC_LINK_MODE_S 0

#define EMAC_GMAC_WATCHDOG_TIMEOUT_REG (REG_EMAC_BASE + 0x10DC)
#define EMAC_PROGRAMMABLE_WATCHDOG_ENABLE (BIT(16))
#define EMAC_PROGRAMMABLE_WATCHDOG_ENABLE_M (BIT(16))
#define EMAC_PROGRAMMABLE_WATCHDOG_ENABLE_V 1
#define EMAC_PROGRAMMABLE_WATCHDOG_ENABLE_S 16
#define EMAC_WATCHDOG_TIMEOUT 0x00003FFF
#define EMAC_WATCHDOG_TIMEOUT_M (EMAC_WATCHDOG_TIMEOUT_V << EMAC_WATCHDOG_TIMEOUT_S)
#define EMAC_WATCHDOG_TIMEOUT_V 0x00003FFF
#define EMAC_WATCHDOG_TIMEOUT_S 0

#define EMAC_GMAC_GENERAL_PURPOSE_IO_REG (REG_EMAC_BASE + 0x10E0)
#define EMAC_GPI_TYPE 0x0000000F
#define EMAC_GPI_TYPE_M (EMAC_GPI_TYPE_V << EMAC_GPI_TYPE_S)
#define EMAC_GPI_TYPE_V 0x0000000F
#define EMAC_GPI_TYPE_S 24
#define EMAC_GPI_INTERRUPT_ENABLE 0x0000000F
#define EMAC_GPI_INTERRUPT_ENABLE_M (EMAC_GPI_INTERRUPT_ENABLE_V << EMAC_GPI_INTERRUPT_ENABLE_S)
#define EMAC_GPI_INTERRUPT_ENABLE_V 0x0000000F
#define EMAC_GPI_INTERRUPT_ENABLE_S 16
#define EMAC_GENERAL_PURPOSE_OUTPUT 0x0000000F
#define EMAC_GENERAL_PURPOSE_OUTPUT_M (EMAC_GENERAL_PURPOSE_OUTPUT_V << EMAC_GENERAL_PURPOSE_OUTPUT_S)
#define EMAC_GENERAL_PURPOSE_OUTPUT_V 0x0000000F
#define EMAC_GENERAL_PURPOSE_OUTPUT_S 8
#define EMAC_GENERAL_PURPOSE_INPUT_STATUS 0x0000000F
#define EMAC_GENERAL_PURPOSE_INPUT_STATUS_M (EMAC_GENERAL_PURPOSE_INPUT_STATUS_V << EMAC_GENERAL_PURPOSE_INPUT_STATUS_S)
#define EMAC_GENERAL_PURPOSE_INPUT_STATUS_V 0x0000000F
#define EMAC_GENERAL_PURPOSE_INPUT_STATUS_S 0

#define EMAC_GMAC_LAYER3_LAYER4_CONTROL0_REG (REG_EMAC_BASE + 0x1400)
#define EMAC_LAYER4_DESTINATION_PORT_INVERSE_MATCH_ENABLE (BIT(21))
#define EMAC_LAYER4_DESTINATION_PORT_INVERSE_MATCH_ENABLE_M (BIT(21))
#define EMAC_LAYER4_DESTINATION_PORT_INVERSE_MATCH_ENABLE_V 1
#define EMAC_LAYER4_DESTINATION_PORT_INVERSE_MATCH_ENABLE_S 21
#define EMAC_LAYER4_DESTINATION_PORT_MATCH_ENABLE (BIT(20))
#define EMAC_LAYER4_DESTINATION_PORT_MATCH_ENABLE_M (BIT(20))
#define EMAC_LAYER4_DESTINATION_PORT_MATCH_ENABLE_V 1
#define EMAC_LAYER4_DESTINATION_PORT_MATCH_ENABLE_S 20
#define EMAC_LAYER4_SOURCE_PORT_INVERSE_MATCH_ENABLE (BIT(19))
#define EMAC_LAYER4_SOURCE_PORT_INVERSE_MATCH_ENABLE_M (BIT(19))
#define EMAC_LAYER4_SOURCE_PORT_INVERSE_MATCH_ENABLE_V 1
#define EMAC_LAYER4_SOURCE_PORT_INVERSE_MATCH_ENABLE_S 19
#define EMAC_LAYER4_SOURCE_PORT_MATCH_ENABLE (BIT(18))
#define EMAC_LAYER4_SOURCE_PORT_MATCH_ENABLE_M (BIT(18))
#define EMAC_LAYER4_SOURCE_PORT_MATCH_ENABLE_V 1
#define EMAC_LAYER4_SOURCE_PORT_MATCH_ENABLE_S 18
#define EMAC_LAYER4_PROTOCOL_ENABLE (BIT(16))
#define EMAC_LAYER4_PROTOCOL_ENABLE_M (BIT(16))
#define EMAC_LAYER4_PROTOCOL_ENABLE_V 1
#define EMAC_LAYER4_PROTOCOL_ENABLE_S 16
#define EMAC_LAYER3_IP_DA_HIGHER_BITS_MATCH 0x0000001F
#define EMAC_LAYER3_IP_DA_HIGHER_BITS_MATCH_M (EMAC_LAYER3_IP_DA_HIGHER_BITS_MATCH_V << EMAC_LAYER3_IP_DA_HIGHER_BITS_MATCH_S)
#define EMAC_LAYER3_IP_DA_HIGHER_BITS_MATCH_V 0x0000001F
#define EMAC_LAYER3_IP_DA_HIGHER_BITS_MATCH_S 11
#define EMAC_LAYER3_IP_SA_HIGHER_BITS_MATCH 0x0000001F
#define EMAC_LAYER3_IP_SA_HIGHER_BITS_MATCH_M (EMAC_LAYER3_IP_SA_HIGHER_BITS_MATCH_V << EMAC_LAYER3_IP_SA_HIGHER_BITS_MATCH_S)
#define EMAC_LAYER3_IP_SA_HIGHER_BITS_MATCH_V 0x0000001F
#define EMAC_LAYER3_IP_SA_HIGHER_BITS_MATCH_S 6
#define EMAC_LAYER3_IP_DA_INVERSE_MATCH_ENABLE (BIT(5))
#define EMAC_LAYER3_IP_DA_INVERSE_MATCH_ENABLE_M (BIT(5))
#define EMAC_LAYER3_IP_DA_INVERSE_MATCH_ENABLE_V 1
#define EMAC_LAYER3_IP_DA_INVERSE_MATCH_ENABLE_S 5
#define EMAC_LAYER3_IP_DA_MATCH_ENABLE (BIT(4))
#define EMAC_LAYER3_IP_DA_MATCH_ENABLE_M (BIT(4))
#define EMAC_LAYER3_IP_DA_MATCH_ENABLE_V 1
#define EMAC_LAYER3_IP_DA_MATCH_ENABLE_S 4
#define EMAC_LAYER3_IP_SA_INVERSE_MATCH_ENABLE (BIT(3))
#define EMAC_LAYER3_IP_SA_INVERSE_MATCH_ENABLE_M (BIT(3))
#define EMAC_LAYER3_IP_SA_INVERSE_MATCH_ENABLE_V 1
#define EMAC_LAYER3_IP_SA_INVERSE_MATCH_ENABLE_S 3
#define EMAC_LAYER3_IP_SA_MATCH_ENABLE (BIT(2))
#define EMAC_LAYER3_IP_SA_MATCH_ENABLE_M (BIT(2))
#define EMAC_LAYER3_IP_SA_MATCH_ENABLE_V 1
#define EMAC_LAYER3_IP_SA_MATCH_ENABLE_S 2
#define EMAC_LAYER3_PROTOCOL_ENABLE (BIT(0))
#define EMAC_LAYER3_PROTOCOL_ENABLE_M (BIT(0))
#define EMAC_LAYER3_PROTOCOL_ENABLE_V 1
#define EMAC_LAYER3_PROTOCOL_ENABLE_S 0

#define EMAC_GMAC_LAYER4_ADDRESS0_REG (REG_EMAC_BASE + 0x1404)
#define EMAC_LAYER4_DESTINATION_PORT_NUMBER_FIELD 0x0000FFFF
#define EMAC_LAYER4_DESTINATION_PORT_NUMBER_FIELD_M (EMAC_LAYER4_DESTINATION_PORT_NUMBER_FIELD_V << EMAC_LAYER4_DESTINATION_PORT_NUMBER_FIELD_S)
#define EMAC_LAYER4_DESTINATION_PORT_NUMBER_FIELD_V 0x0000FFFF
#define EMAC_LAYER4_DESTINATION_PORT_NUMBER_FIELD_S 16
#define EMAC_LAYER4_SOURCE_PORT_NUMBER_FIELD 0x0000FFFF
#define EMAC_LAYER4_SOURCE_PORT_NUMBER_FIELD_M (EMAC_LAYER4_SOURCE_PORT_NUMBER_FIELD_V << EMAC_LAYER4_SOURCE_PORT_NUMBER_FIELD_S)
#define EMAC_LAYER4_SOURCE_PORT_NUMBER_FIELD_V 0x0000FFFF
#define EMAC_LAYER4_SOURCE_PORT_NUMBER_FIELD_S 0

#define EMAC_GMAC_LAYER3_ADDRESS0_REG (REG_EMAC_BASE + 0x1410)
#define EMAC_LAYER3_ADDRESS0_FIELD 0xFFFFFFFF
#define EMAC_LAYER3_ADDRESS0_FIELD_M (EMAC_LAYER3_ADDRESS0_FIELD_V << EMAC_LAYER3_ADDRESS0_FIELD_S)
#define EMAC_LAYER3_ADDRESS0_FIELD_V 0xFFFFFFFF
#define EMAC_LAYER3_ADDRESS0_FIELD_S 0

#define EMAC_GMAC_LAYER3_ADDRESS1_REG (REG_EMAC_BASE + 0x1414)
#define EMAC_LAYER3_ADDRESS1_FIELD 0xFFFFFFFF
#define EMAC_LAYER3_ADDRESS1_FIELD_M (EMAC_LAYER3_ADDRESS1_FIELD_V << EMAC_LAYER3_ADDRESS1_FIELD_S)
#define EMAC_LAYER3_ADDRESS1_FIELD_V 0xFFFFFFFF
#define EMAC_LAYER3_ADDRESS1_FIELD_S 0

#define EMAC_GMAC_LAYER3_ADDRESS2_REG (REG_EMAC_BASE + 0x1418)
#define EMAC_LAYER3_ADDRESS2_FIELD 0xFFFFFFFF
#define EMAC_LAYER3_ADDRESS2_FIELD_M (EMAC_LAYER3_ADDRESS2_FIELD_V << EMAC_LAYER3_ADDRESS2_FIELD_S)
#define EMAC_LAYER3_ADDRESS2_FIELD_V 0xFFFFFFFF
#define EMAC_LAYER3_ADDRESS2_FIELD_S 0

#define EMAC_GMAC_LAYER3_ADDRESS3_REG (REG_EMAC_BASE + 0x141C)
#define EMAC_LAYER3_ADDRESS3_FIELD 0xFFFFFFFF
#define EMAC_LAYER3_ADDRESS3_FIELD_M (EMAC_LAYER3_ADDRESS3_FIELD_V << EMAC_LAYER3_ADDRESS3_FIELD_S)
#define EMAC_LAYER3_ADDRESS3_FIELD_V 0xFFFFFFFF
#define EMAC_LAYER3_ADDRESS3_FIELD_S 0

#define EMAC_GMAC_HASH_TABLE0_REG (REG_EMAC_BASE + 0x1500)
#define EMAC_FIRST32_BITS_HASH_TABLE 0xFFFFFFFF
#define EMAC_FIRST32_BITS_HASH_TABLE_M (EMAC_FIRST32_BITS_HASH_TABLE_V << EMAC_FIRST32_BITS_HASH_TABLE_S)
#define EMAC_FIRST32_BITS_HASH_TABLE_V 0xFFFFFFFF
#define EMAC_FIRST32_BITS_HASH_TABLE_S 0

#define EMAC_GMAC_VLAN_TAG_INCLUSION_REPLACEMENT_REG (REG_EMAC_BASE + 0x1584)
#define EMAC_VLAN_C_VLAN_S_VLAN (BIT(19))
#define EMAC_VLAN_C_VLAN_S_VLAN_M (BIT(19))
#define EMAC_VLAN_C_VLAN_S_VLAN_V 1
#define EMAC_VLAN_C_VLAN_S_VLAN_S 19
#define EMAC_VLAN_PRIORITY_CONTROL (BIT(18))
#define EMAC_VLAN_PRIORITY_CONTROL_M (BIT(18))
#define EMAC_VLAN_PRIORITY_CONTROL_V 1
#define EMAC_VLAN_PRIORITY_CONTROL_S 18
#define EMAC_VLAN_TAG_CONTROL_TRANSMIT_FRAMES 0x00000003
#define EMAC_VLAN_TAG_CONTROL_TRANSMIT_FRAMES_M (EMAC_VLAN_TAG_CONTROL_TRANSMIT_FRAMES_V << EMAC_VLAN_TAG_CONTROL_TRANSMIT_FRAMES_S)
#define EMAC_VLAN_TAG_CONTROL_TRANSMIT_FRAMES_V 0x00000003
#define EMAC_VLAN_TAG_CONTROL_TRANSMIT_FRAMES_S 16
#define EMAC_VLAN_TAG_TRANSMIT_FRAMES 0x0000FFFF
#define EMAC_VLAN_TAG_TRANSMIT_FRAMES_M (EMAC_VLAN_TAG_TRANSMIT_FRAMES_V << EMAC_VLAN_TAG_TRANSMIT_FRAMES_S)
#define EMAC_VLAN_TAG_TRANSMIT_FRAMES_V 0x0000FFFF
#define EMAC_VLAN_TAG_TRANSMIT_FRAMES_S 0

#define EMAC_GMAC_VLAN_HASH_TABLE_REG (REG_EMAC_BASE + 0x1588)
#define EMAC_VLAN_HASH_TABLE 0x0000FFFF
#define EMAC_VLAN_HASH_TABLE_M (EMAC_VLAN_HASH_TABLE_V << EMAC_VLAN_HASH_TABLE_S)
#define EMAC_VLAN_HASH_TABLE_V 0x0000FFFF
#define EMAC_VLAN_HASH_TABLE_S 0

#ifdef __cplusplus
}
#endif

#endif

