// The rotary encoder library http://www.pjrc.com/teensy/td_libs_Encoder.html


#include <Mouse.h>
#include <Keyboard.h>
#include <Button.h>
#include <ButtonEventCallback.h>
#include <PushButton.h>
#include <BasicButton.h>
#include <Bounce2.h>
 

const int Task = 15;
const int QuickMenu = 14;
const int ESC = 16;
const int debounce_delay = 300;

const int pinBlue = 19;
const int pinGreen = 20;
const int pinRed = 21;

const int Option_switch_pin = 6;  // Option switch

const int Option_max = 3;
int Option_state = 0;

const int pinBrightness = 10;
const int maxBrightness = 255;
int Brightness = 0; // 0 - 255 75% = 0.75 / 255

// Encoder UP DOWN
const int rotaryUpDown1 = 2; //Encoder pin A connects to interrupt 0 (D2)
const int rotaryUpDown2 = 4; //Encoder pin B connects to D4

// Encoder LEFT RIGHT LeftRight 
const int rotaryLeftRight1 = 3; //Encoder pin A connects to interrupt 0 (D2)
const int rotaryLeftRight2 = 5; //Encoder pin B connects to D4

PushButton Option_switch = PushButton(Option_switch_pin, ENABLE_INTERNAL_PULLUP);

/* The analog pin number for brightness measurement A9 */
const byte ambientBrightness1 = A9;
const byte ambientBrightness2 = A11;

/* Coefficient diviseur du pont de résistance */
const float COEFF_PONT_DIVISEUR_VIN = 4.0;

const int PIN_LED_RXL = 8;
const int PIN_LED_TXL = 22;

void setup() {
  Serial.begin(9600);
  Option_switch.onPress(onOption_switch);
  //Option_switch.onRelease(onOption_switch);

  analogWrite(pinBrightness, Brightness); // éclaire notre DEL à 75%

  pinMode(26, INPUT);
  pinMode(29, INPUT);

  pinMode(pinBlue, OUTPUT);
  pinMode(pinGreen, OUTPUT);
  pinMode(pinRed, OUTPUT);

  pinMode(rotaryUpDown1, INPUT_PULLUP);  
  digitalWrite(rotaryUpDown1, HIGH);
  pinMode(rotaryUpDown2, INPUT_PULLUP);
  digitalWrite(rotaryUpDown2, HIGH);

  pinMode(rotaryLeftRight1, INPUT_PULLUP);  
  digitalWrite(rotaryLeftRight1, HIGH);
  pinMode(rotaryLeftRight2, INPUT_PULLUP);
  digitalWrite(rotaryLeftRight2, HIGH);
  
  // Enable interrupt on encoder pin A
  // Trigger at RISING if your encoder stops (clicks) only at high pulse
  // Trigger at CHANGE if your encoder stops (clicks) at both high and low
  // positions or if it has no stops
  attachInterrupt(digitalPinToInterrupt(rotaryUpDown1),rotaryUpDownClick, CHANGE);
  attachInterrupt(digitalPinToInterrupt(rotaryLeftRight1),rotaryLeftRightClick, CHANGE);
}


void loop() {
   //int valeur1 = analogRead(ambientBrightness1);
   int valeur2 = analogRead(ambientBrightness2);
   delay(2000);
   Serial.println();
   //Serial.println(valeur1);
   Serial.println(valeur2);

   Option_switch.update();
   
   switch (Option_state) {
    case 0:
      digitalWrite(pinBlue, HIGH);
      digitalWrite(pinGreen, HIGH);
      digitalWrite(pinRed, HIGH);
      break;
    case 1:
      digitalWrite(pinGreen, HIGH);
      digitalWrite(pinRed, HIGH);
      digitalWrite(pinBlue, LOW);
      break;
    case 2:
      digitalWrite(pinBlue, HIGH);
      digitalWrite(pinGreen, HIGH);
      digitalWrite(pinRed, LOW);
      break;
    case 3:
      digitalWrite(pinBlue, HIGH);
      digitalWrite(pinRed, HIGH);
      digitalWrite(pinGreen, LOW);
      break;
    default: 
      digitalWrite(pinBlue, HIGH);
      digitalWrite(pinGreen, HIGH);
      digitalWrite(pinRed, HIGH);
  }
   /*delay(2000);
   digitalWrite(pinBlue, LOW);
   delay(1000);
   digitalWrite(pinBlue, HIGH);
   delay(2000);
   digitalWrite(pinGreen, LOW);
   delay(1000);
   digitalWrite(pinGreen, HIGH);
   delay(2000);
   digitalWrite(pinRed, LOW);
   delay(1000);
   digitalWrite(pinRed, HIGH);
   delay(2000);
   digitalWrite(pinBlue, LOW);
   digitalWrite(pinGreen, LOW);
   digitalWrite(pinRed, LOW);   
   delay(2000);
   digitalWrite(pinBlue, HIGH);
   digitalWrite(pinGreen, HIGH);
   digitalWrite(pinRed, HIGH); */
}

void onOption_switch(Button& btn){
  if(Option_switch.isPressed())
    { Option_state++;
      if (Option_state > Option_max) { Option_state = 0; }
      Serial.println(Option_state);
    }
  else
    { Serial.println("toto");
      digitalWrite(pinRed, LOW);
      Keyboard.releaseAll(); 
    }
}

void rotaryUpDownClick(){
  // encoder must have turned one click because interrupt 0 was triggered
  // read value from both encoder pins
  int rtyUpDown1 = digitalRead(rotaryUpDown1);
  int rtyUpDown2 = digitalRead(rotaryUpDown2);
  // compare pins to determine in which direction encoder was turned
       if (rtyUpDown2 != rtyUpDown1){
          // pinA just changed but pinB had not yet changed
          // Direction must be clockwise if A changes before B
            switch (Option_state) {
               case 0:
                  Keyboard.write(KEY_DOWN_ARROW);  //ASCII 0x31
                  break;
               case 1:
                  if (Brightness < maxBrightness) {
                     Brightness++;
                     Serial.println(Brightness);
                     analogWrite(pinBrightness, Brightness);
                  }
                  break;
               case 2:
                  break;
               case 3:
                  break;
            }
          }
       else{
          // pinA just changed and pinB had already done so.
          // Direction must be counter-clockwise if B changes before A
            switch (Option_state) {
               case 0:
                  Keyboard.write(KEY_UP_ARROW);  //ASCII 0x32
                    break;
               case 1:
                  if (Brightness > 0) {
                     Brightness--;
                     Serial.println(Brightness);
                     analogWrite(pinBrightness, Brightness);
                  }
                  break;
               case 2:
                  break;
               case 3:
                  break;
          }
       }
}

void rotaryLeftRightClick(){
  // encoder must have turned one click because interrupt 0 was triggered
  // read value from both encoder pins
  int rtyLeftRight1 = digitalRead(rotaryLeftRight1);
  int rtyLeftRight2 = digitalRead(rotaryLeftRight2);
  // compare pins to determine in which direction encoder was turned
  if (rtyLeftRight2 != rtyLeftRight1){
      // pinA just changed but pinB had not yet changed
      // Direction must be clockwise if A changes before B
      Keyboard.write(KEY_LEFT_ARROW);  //ASCII 0x31
     }
     else{
       // pinA just changed and pinB had already done so.
       // Direction must be counter-clockwise if B changes before A
       Keyboard.write(KEY_RIGHT_ARROW);  //ASCII 0x32
    }
}

