/*
   Basecamp - ESP32 library to simplify the basics of IoT projects
   Written by Merlin Schumacher (mls@ct.de) for c't magazin für computer technik (https://www.ct.de)
   Licensed under GPLv3. See LICENSE for details.
   */

#include <pgmspace.h>
//
// converted data/* to gzipped flash variables
//


#define basecamp_css_gz_len 617
const uint8_t basecamp_css_gz[] PROGMEM {
  0x1f, 0x8b, 0x08, 0x08, 0x3c, 0x8f, 0x74, 0x5a, 0x00, 0x03, 0x62, 0x61,
  0x73, 0x65, 0x63, 0x61, 0x6d, 0x70, 0x2e, 0x63, 0x73, 0x73, 0x00, 0xbd,
  0x54, 0xcb, 0x8e, 0x9b, 0x30, 0x14, 0xfd, 0x15, 0xa4, 0x68, 0xa4, 0x50,
  0x61, 0x64, 0xc8, 0x64, 0x1e, 0x46, 0xad, 0xda, 0x4d, 0xd5, 0x75, 0xb7,
  0xd5, 0x2c, 0x6c, 0x30, 0x60, 0x8d, 0x1f, 0xc8, 0x36, 0x21, 0x29, 0xe2,
  0xdf, 0x6b, 0x63, 0x92, 0x09, 0x93, 0x51, 0xa5, 0x6e, 0xaa, 0xc8, 0x16,
  0xb9, 0xe7, 0xc2, 0x3d, 0xf7, 0xdc, 0x47, 0x6b, 0x05, 0x1f, 0x6b, 0x25,
  0x2d, 0xa8, 0xb1, 0x60, 0xfc, 0x84, 0x7e, 0x2a, 0xa2, 0xac, 0x4a, 0x7e,
  0x50, 0x7e, 0xa0, 0x96, 0x95, 0x38, 0xf9, 0xa6, 0x19, 0xe6, 0x89, 0xc1,
  0xd2, 0x00, 0x43, 0x35, 0xab, 0x0b, 0xce, 0x24, 0x05, 0x2d, 0x65, 0x4d,
  0x6b, 0x51, 0x96, 0xee, 0xa7, 0xaf, 0x82, 0x56, 0x0c, 0x6f, 0x05, 0x93,
  0xa0, 0xa2, 0x07, 0x56, 0x52, 0x30, 0xb0, 0xca, 0xb6, 0xe8, 0x1e, 0xc2,
  0xee, 0x18, 0x8f, 0x9b, 0x41, 0xe3, 0xae, 0xa3, 0x3a, 0xa9, 0x95, 0xb2,
  0x54, 0x8f, 0x01, 0x7c, 0x82, 0x77, 0x85, 0xc0, 0xc7, 0xc5, 0x35, 0x83,
  0xde, 0xd7, 0x19, 0x74, 0xc3, 0x24, 0x82, 0x11, 0xee, 0xad, 0x9a, 0xa6,
  0x36, 0x0b, 0xcc, 0x86, 0x10, 0x6b, 0x07, 0xe1, 0x3a, 0x76, 0x06, 0xef,
  0xa6, 0x36, 0x4f, 0xda, 0x5d, 0xd2, 0xde, 0xaf, 0x3c, 0xa5, 0xd2, 0x02,
  0xf3, 0x5b, 0xe7, 0xee, 0xcc, 0xa1, 0x54, 0x5c, 0x69, 0xa4, 0x1b, 0x82,
  0xb7, 0x30, 0x99, 0x7f, 0xe9, 0x63, 0x16, 0x4f, 0x1c, 0x13, 0xca, 0xc7,
  0x8a, 0x99, 0x8e, 0xe3, 0x13, 0x22, 0x5c, 0x95, 0xaf, 0xd3, 0xf2, 0xc6,
  0xfc, 0x79, 0xc3, 0x7e, 0x53, 0x94, 0x3e, 0x51, 0x31, 0x31, 0xd9, 0xf5,
  0xf6, 0x97, 0x3d, 0x75, 0xf4, 0xb3, 0xa5, 0x47, 0xfb, 0x92, 0x5c, 0x19,
  0x3a, 0x6c, 0xcc, 0xa0, 0x74, 0xb5, 0x32, 0xca, 0x5e, 0x10, 0xaa, 0x17,
  0x93, 0x23, 0x68, 0xb7, 0xb3, 0xfd, 0x25, 0x5e, 0x87, 0x5b, 0x24, 0x00,
  0xae, 0x06, 0x56, 0x09, 0x94, 0x51, 0x51, 0x5c, 0x14, 0xba, 0xbb, 0x8e,
  0x4a, 0x7a, 0xe7, 0x20, 0x57, 0x21, 0x4c, 0x4f, 0x04, 0x73, 0x54, 0x02,
  0x94, 0xe0, 0x34, 0x3c, 0x8c, 0xc4, 0x71, 0xa1, 0x1a, 0xc1, 0x22, 0x3c,
  0x00, 0x8d, 0x2b, 0xd6, 0x1b, 0x94, 0x3b, 0xc1, 0x09, 0x2e, 0x5f, 0x1b,
  0xad, 0x7a, 0x59, 0xa1, 0x4d, 0xfe, 0x80, 0x1f, 0x9e, 0x71, 0x11, 0xa4,
  0x19, 0x5a, 0x66, 0x69, 0x51, 0xf6, 0xda, 0xb8, 0x3f, 0x9d, 0x62, 0xd2,
  0x69, 0x50, 0xbc, 0x69, 0x90, 0xa5, 0xf9, 0xde, 0x51, 0x5b, 0x09, 0xbc,
  0x77, 0x15, 0x25, 0xea, 0x08, 0x4c, 0x8b, 0x2b, 0x35, 0xac, 0xc5, 0xcd,
  0xee, 0xe3, 0x08, 0x46, 0x2e, 0xe2, 0x7c, 0x60, 0xb2, 0x06, 0x73, 0x0f,
  0x66, 0x0e, 0xd8, 0xdf, 0x82, 0x33, 0xb6, 0x73, 0x76, 0x8f, 0x03, 0xcf,
  0xf9, 0x9f, 0x9a, 0xf5, 0x03, 0xc9, 0x50, 0xab, 0x0e, 0xae, 0x1b, 0x6f,
  0x85, 0x5b, 0x80, 0x77, 0xf2, 0x05, 0xeb, 0xf8, 0xa6, 0x14, 0x08, 0x0a,
  0x6d, 0x72, 0x42, 0x08, 0xae, 0xae, 0x53, 0x0e, 0x44, 0xfd, 0x81, 0xd1,
  0xfb, 0xf4, 0x93, 0x90, 0xe1, 0xe3, 0x07, 0x60, 0xee, 0xc1, 0x4b, 0x8a,
  0xfe, 0x7a, 0xa7, 0xc0, 0x94, 0x1a, 0xce, 0x04, 0x08, 0xe5, 0x5b, 0xca,
  0xb9, 0x74, 0xc8, 0x79, 0x7e, 0x7c, 0x2d, 0x57, 0x76, 0x63, 0x4f, 0x9c,
  0x22, 0xa3, 0x38, 0xab, 0xce, 0x08, 0x13, 0xb8, 0xa1, 0xc8, 0xd7, 0x0c,
  0x6b, 0xd0, 0xf8, 0x2e, 0xa0, 0xd2, 0x6e, 0xad, 0x8a, 0xb4, 0x2f, 0x60,
  0x90, 0x3d, 0x7b, 0xce, 0x93, 0xcb, 0x89, 0x57, 0xa5, 0x88, 0xe3, 0x28,
  0x83, 0x53, 0x5a, 0x63, 0xfb, 0x37, 0x26, 0xbb, 0xff, 0xc7, 0x64, 0xc0,
  0x5a, 0x32, 0xd9, 0x2c, 0xc3, 0xbc, 0xf9, 0xee, 0xd6, 0xc3, 0xf5, 0x12,
  0x20, 0x8a, 0x57, 0xd3, 0xa6, 0x54, 0xb2, 0x66, 0x4d, 0xed, 0x16, 0xc2,
  0x65, 0xd0, 0x6a, 0x4e, 0x5d, 0x17, 0xb9, 0x0b, 0xf8, 0xcd, 0x84, 0xfc,
  0x75, 0xed, 0xf7, 0xe5, 0xd3, 0xe8, 0x41, 0x94, 0x45, 0xf3, 0xcc, 0x6d,
  0xe6, 0xa5, 0xe0, 0x00, 0x83, 0x0f, 0x74, 0xfe, 0x4e, 0x18, 0x27, 0x07,
  0x3a, 0x4c, 0x35, 0x6a, 0x3c, 0x0f, 0xc0, 0x65, 0x56, 0xfd, 0xf6, 0x3a,
  0x0f, 0xf2, 0x9c, 0x11, 0x9a, 0xc7, 0x65, 0xfa, 0x03, 0x11, 0x2c, 0x71,
  0x8d, 0x6c, 0x05, 0x00, 0x00
};
#define basecamp_js_gz_len 1029
const uint8_t basecamp_js_gz[] PROGMEM {
  0x1f, 0x8b, 0x08, 0x08, 0x3c, 0x8f, 0x74, 0x5a, 0x00, 0x03, 0x62, 0x61,
  0x73, 0x65, 0x63, 0x61, 0x6d, 0x70, 0x2e, 0x6a, 0x73, 0x00, 0xa5, 0x56,
  0xdf, 0x6f, 0xdb, 0x36, 0x10, 0xfe, 0x57, 0x58, 0x16, 0x08, 0xa4, 0x46,
  0xd1, 0x12, 0x74, 0x4f, 0xd6, 0xd4, 0x21, 0x4d, 0xbb, 0xad, 0x43, 0xd6,
  0x16, 0x75, 0x80, 0x0d, 0x30, 0xfc, 0x40, 0x8a, 0x27, 0x89, 0x09, 0x23,
  0x7a, 0x24, 0x15, 0xcf, 0x30, 0xf4, 0xbf, 0xf7, 0x48, 0x4b, 0x96, 0x94,
  0x3a, 0x4f, 0x7b, 0x89, 0xe3, 0xe3, 0xdd, 0x77, 0xdf, 0xfd, 0xf6, 0xbd,
  0xd5, 0xcd, 0x07, 0xe6, 0x58, 0x4e, 0x05, 0xfe, 0x4d, 0xef, 0xf1, 0x2b,
  0xcd, 0xca, 0xb6, 0x29, 0x9c, 0xd4, 0x0d, 0x51, 0x9a, 0x89, 0x28, 0xde,
  0x17, 0xba, 0xb1, 0x5a, 0x41, 0xaa, 0x74, 0x15, 0xd1, 0xf7, 0xcc, 0x42,
  0xc1, 0x1e, 0x37, 0xe1, 0x11, 0x04, 0x8d, 0xb3, 0x27, 0x66, 0x08, 0xcf,
  0x1b, 0xd8, 0x92, 0x7f, 0xfe, 0xba, 0xfd, 0xc3, 0xb9, 0xcd, 0x37, 0xf8,
  0xb7, 0x05, 0xeb, 0xa2, 0x78, 0x44, 0x2a, 0x10, 0xc6, 0xeb, 0x89, 0xfc,
  0xcf, 0xe5, 0x97, 0xcf, 0xe9, 0x86, 0x19, 0x0b, 0x91, 0xab, 0xa5, 0x4d,
  0x0d, 0xd8, 0x0d, 0xe2, 0xc3, 0x1d, 0xfc, 0xe7, 0xe2, 0x8c, 0xb7, 0x52,
  0x89, 0xa5, 0x74, 0x10, 0x89, 0x14, 0x14, 0x3c, 0x42, 0xe3, 0x6c, 0xdc,
  0x1d, 0x61, 0x58, 0x24, 0x9e, 0xd1, 0xb9, 0xd5, 0xfa, 0xc1, 0x12, 0x25,
  0x1f, 0x80, 0xb8, 0x1a, 0x0c, 0x90, 0x2d, 0xb3, 0x84, 0x91, 0x8d, 0xd1,
  0x1c, 0xcd, 0x53, 0xb2, 0x74, 0xcc, 0xb5, 0x96, 0xdc, 0x68, 0x01, 0x0b,
  0x42, 0xcf, 0x79, 0x6a, 0x83, 0x20, 0xce, 0x98, 0x10, 0x1f, 0x0f, 0x0e,
  0xee, 0xf4, 0x07, 0xfd, 0x18, 0xd1, 0xfa, 0x8a, 0x26, 0x14, 0x8c, 0xd1,
  0x06, 0x3f, 0x6f, 0x74, 0xab, 0x04, 0x69, 0xb4, 0x0b, 0x61, 0x12, 0x74,
  0x59, 0xca, 0xaa, 0x35, 0xcc, 0xb3, 0x98, 0xe2, 0x24, 0x7b, 0xeb, 0x76,
  0x0a, 0x16, 0xb4, 0xd0, 0x4a, 0x9b, 0x85, 0xc1, 0x84, 0x74, 0x71, 0x66,
  0xc0, 0xb5, 0xa6, 0xe9, 0x78, 0xea, 0x9d, 0x3c, 0xa1, 0x8b, 0x5b, 0x69,
  0x1d, 0x34, 0x60, 0x22, 0xea, 0xe1, 0x68, 0x52, 0x60, 0xa4, 0x27, 0x1e,
  0x7b, 0xef, 0xcc, 0xbf, 0xea, 0x0d, 0x34, 0x11, 0xfd, 0xfd, 0xe3, 0x1d,
  0x4d, 0xee, 0xfb, 0x22, 0x79, 0xb1, 0x85, 0x06, 0x4b, 0x32, 0x66, 0x64,
  0x60, 0x06, 0x7d, 0x30, 0x11, 0x8b, 0xf7, 0x76, 0x2b, 0x5d, 0x51, 0x47,
  0x6c, 0xc8, 0x20, 0xa6, 0x0c, 0x8b, 0x46, 0x65, 0xb3, 0x69, 0x1d, 0x5d,
  0xc8, 0x12, 0x5f, 0xd0, 0xcc, 0x85, 0x17, 0xc5, 0x38, 0xa8, 0x4f, 0x22,
  0xa7, 0xe1, 0x9f, 0x12, 0xdd, 0x9f, 0xb3, 0x54, 0x8a, 0x2c, 0x7c, 0xbd,
  0x76, 0xce, 0xe4, 0x7b, 0xea, 0xa5, 0x0b, 0x2f, 0xed, 0xb2, 0x69, 0xee,
  0x47, 0x94, 0x1f, 0x93, 0x19, 0xcc, 0x69, 0xd2, 0xa3, 0x27, 0x47, 0xd5,
  0xe4, 0x88, 0x8b, 0x32, 0xec, 0x82, 0xd3, 0xd6, 0x07, 0xa6, 0x89, 0x77,
  0x99, 0x50, 0xff, 0xc9, 0xd0, 0x40, 0xf2, 0xd6, 0x81, 0x4d, 0xe8, 0x6b,
  0x7a, 0xde, 0xc3, 0xc6, 0x1d, 0x28, 0x0b, 0xfb, 0xe7, 0xe6, 0xc7, 0xb8,
  0x0f, 0x00, 0xa3, 0xef, 0x19, 0xce, 0xd1, 0x7d, 0xc7, 0x0d, 0xb0, 0x87,
  0x4c, 0x40, 0xc9, 0x5a, 0xe5, 0x16, 0xff, 0x13, 0x2d, 0x0b, 0x68, 0xdd,
  0xa4, 0x65, 0x9f, 0xe1, 0x15, 0x09, 0x4f, 0xe0, 0x30, 0x0c, 0x65, 0xce,
  0x4c, 0xd5, 0x86, 0x1e, 0x4f, 0x15, 0x34, 0x95, 0xab, 0xdf, 0xbd, 0x3d,
  0x3b, 0x3b, 0xca, 0x56, 0x6f, 0xd7, 0xaf, 0xf2, 0xbc, 0x6d, 0x90, 0x99,
  0x6c, 0x40, 0xfc, 0x3a, 0x7d, 0x58, 0xec, 0xbb, 0x30, 0x77, 0xd5, 0x08,
  0xb1, 0xfa, 0x79, 0x1d, 0x44, 0x75, 0x2e, 0x74, 0x11, 0x44, 0x69, 0x81,
  0x5c, 0xdc, 0xb1, 0x33, 0xb0, 0xe9, 0xb0, 0xf6, 0xbd, 0x6f, 0xf6, 0x5c,
  0xcb, 0xcf, 0xdf, 0x67, 0x9c, 0x12, 0x54, 0xc8, 0xea, 0x94, 0x6d, 0xb0,
  0xfd, 0xc4, 0x4d, 0x8d, 0xd3, 0x88, 0x1d, 0xd5, 0xa1, 0x1d, 0x8f, 0xf7,
  0x35, 0x76, 0x9f, 0xbb, 0x1e, 0x82, 0xc6, 0x32, 0x61, 0x27, 0xf3, 0xb8,
  0x9b, 0x0a, 0x6d, 0x54, 0x27, 0xe5, 0x61, 0x25, 0x88, 0xd1, 0x03, 0xae,
  0x03, 0xb3, 0x5b, 0x62, 0x1e, 0x0b, 0xa7, 0x4d, 0x54, 0x05, 0x1e, 0xaf,
  0x70, 0x92, 0x5f, 0x54, 0xa1, 0xaf, 0xb7, 0xc6, 0x53, 0x30, 0x34, 0xee,
  0xc4, 0x8c, 0x4c, 0x3d, 0xe9, 0xfd, 0xb9, 0xe3, 0x02, 0xe7, 0x66, 0x8f,
  0xad, 0x1a, 0x85, 0x7d, 0x44, 0x24, 0xa6, 0x3e, 0xde, 0xfb, 0x66, 0x5f,
  0xf1, 0x35, 0x4e, 0xc0, 0x9c, 0x3b, 0x4f, 0x82, 0xb8, 0x9b, 0x14, 0x6a,
  0x5c, 0x3d, 0xc5, 0x21, 0x45, 0x3c, 0x1f, 0x69, 0xcc, 0x1a, 0x1f, 0x13,
  0xb9, 0x45, 0x32, 0xa8, 0x38, 0x94, 0xed, 0x72, 0xd8, 0x6e, 0xab, 0x75,
  0x36, 0x50, 0x60, 0xf9, 0x65, 0xc6, 0x7e, 0x19, 0x54, 0x32, 0x76, 0x7e,
  0x1e, 0xe8, 0x14, 0x2b, 0xb6, 0xee, 0x9b, 0x25, 0xcf, 0x31, 0xa9, 0x22,
  0xdd, 0xb4, 0xb6, 0x0e, 0xe2, 0x38, 0x43, 0x96, 0x1b, 0x25, 0x0b, 0x88,
  0x58, 0x72, 0x35, 0xb6, 0xd2, 0x0c, 0x50, 0xcc, 0x00, 0x7f, 0x18, 0x7f,
  0xe1, 0x71, 0x7c, 0xbd, 0xa6, 0xdc, 0x78, 0x5e, 0xac, 0x2e, 0x07, 0xaf,
  0xd3, 0x98, 0x71, 0x6b, 0xf9, 0x8c, 0xdf, 0x4c, 0xd7, 0x1b, 0x6e, 0xea,
  0x63, 0x55, 0x2a, 0x70, 0x3d, 0xf0, 0xfb, 0xdd, 0x27, 0x11, 0xd1, 0xbf,
  0x65, 0x29, 0x07, 0x65, 0xbf, 0xfb, 0xd3, 0x27, 0xa6, 0x5a, 0xc8, 0xe9,
  0x9d, 0x69, 0x81, 0x86, 0xaa, 0x17, 0xe1, 0x10, 0xfc, 0xa6, 0xcd, 0xa3,
  0xdf, 0x58, 0x78, 0x02, 0x66, 0xab, 0xb3, 0x07, 0xb3, 0x63, 0xdd, 0xb9,
  0x16, 0xbb, 0x79, 0xf1, 0xaf, 0x95, 0x8a, 0xe8, 0x9b, 0x95, 0xbf, 0x47,
  0x17, 0x07, 0xe3, 0x35, 0x1e, 0x99, 0x21, 0x09, 0x22, 0x3f, 0x09, 0xd8,
  0x07, 0x7b, 0x71, 0x95, 0x89, 0x77, 0x98, 0x26, 0x71, 0x71, 0x71, 0xa8,
  0x48, 0x75, 0x5a, 0x7d, 0x25, 0xd6, 0x3e, 0xb6, 0x49, 0x2f, 0x4f, 0xdc,
  0xf5, 0x27, 0x8d, 0xbd, 0x6c, 0x1a, 0xa2, 0xf6, 0x4d, 0xfc, 0xa2, 0x46,
  0xcd, 0xec, 0x04, 0xdc, 0xe0, 0x41, 0x94, 0x21, 0x61, 0x38, 0xde, 0x79,
  0x4e, 0x69, 0xbc, 0x67, 0x0a, 0x8c, 0x8b, 0xe8, 0x57, 0x05, 0xb8, 0x9a,
  0x49, 0x29, 0x95, 0x22, 0xba, 0x75, 0x84, 0xe1, 0xe7, 0xa0, 0x4d, 0x82,
  0x1b, 0x4b, 0x8f, 0xf7, 0x24, 0x6c, 0xee, 0xa1, 0xaa, 0x67, 0x67, 0xd5,
  0xa4, 0xc2, 0x45, 0x3f, 0x24, 0x51, 0x85, 0x53, 0xd0, 0x75, 0x9e, 0x3f,
  0x9c, 0x3e, 0xc9, 0xf0, 0xe2, 0x51, 0x2a, 0x4f, 0x3f, 0xf6, 0x47, 0x89,
  0xfb, 0xd7, 0xc3, 0x51, 0xfa, 0xfa, 0x65, 0x89, 0x57, 0x89, 0xfe, 0x64,
  0x5b, 0xfe, 0x88, 0x97, 0x66, 0x48, 0xda, 0xec, 0x2e, 0x2f, 0x91, 0x8c,
  0x6c, 0xaa, 0xf9, 0xe5, 0xa4, 0x1e, 0x23, 0x5c, 0xb0, 0x62, 0xf2, 0xdb,
  0x80, 0x47, 0xc7, 0x74, 0xcc, 0x1a, 0x11, 0x6d, 0x87, 0x23, 0xcc, 0x81,
  0x58, 0xf6, 0xe4, 0x13, 0x38, 0xf6, 0x6e, 0xf9, 0x92, 0x59, 0xd0, 0x24,
  0xb6, 0x2d, 0x0a, 0xb0, 0xb6, 0x6c, 0x95, 0xda, 0xa5, 0xe4, 0x1b, 0x70,
  0xad, 0x1d, 0x12, 0x4a, 0x11, 0xa2, 0xdb, 0xca, 0x46, 0xe8, 0x6d, 0xaa,
  0x1b, 0x1f, 0x78, 0x3e, 0x20, 0x22, 0xde, 0xe1, 0x07, 0x4f, 0x97, 0x7d,
  0x07, 0x70, 0xc0, 0x10, 0x4a, 0x17, 0x09, 0x00, 0x00
};
#define index_htm_gz_len 272
const uint8_t index_htm_gz[] PROGMEM {
  0x1f, 0x8b, 0x08, 0x08, 0x3c, 0x8f, 0x74, 0x5a, 0x00, 0x03, 0x69, 0x6e,
  0x64, 0x65, 0x78, 0x2e, 0x68, 0x74, 0x6d, 0x00, 0x55, 0x90, 0xb1, 0x52,
  0xc3, 0x40, 0x0c, 0x44, 0x7b, 0xbe, 0x42, 0xa8, 0x85, 0xc4, 0x03, 0x34,
  0x14, 0x77, 0x6e, 0x20, 0x35, 0x99, 0x81, 0x86, 0xf2, 0x72, 0x56, 0x6c,
  0x85, 0xf3, 0xd9, 0x73, 0x52, 0x1c, 0xcc, 0xd7, 0x23, 0x27, 0x30, 0x03,
  0x8d, 0x46, 0xbb, 0xab, 0x7d, 0x85, 0xdc, 0xf5, 0xf3, 0xcb, 0xd3, 0xdb,
  0xfb, 0x76, 0x03, 0x9d, 0xf6, 0xa9, 0x76, 0xcb, 0x84, 0x14, 0x72, 0xeb,
  0x91, 0x32, 0x9a, 0xa6, 0xd0, 0xd4, 0xae, 0x27, 0x0d, 0x10, 0xbb, 0x50,
  0x84, 0xd4, 0xe3, 0x51, 0xf7, 0xab, 0x47, 0xfc, 0x71, 0x73, 0xe8, 0xc9,
  0xe3, 0xc4, 0x74, 0x1a, 0x87, 0xa2, 0x08, 0x71, 0xc8, 0x4a, 0xd9, 0xae,
  0x4e, 0xdc, 0x68, 0xe7, 0x1b, 0x9a, 0x38, 0xd2, 0xea, 0x2c, 0x6e, 0x81,
  0x33, 0x2b, 0x87, 0xb4, 0x92, 0x18, 0x12, 0xf9, 0x3b, 0x63, 0x24, 0xce,
  0x1f, 0x50, 0x28, 0x79, 0x94, 0xce, 0xfa, 0xf1, 0xa8, 0xc0, 0x86, 0x40,
  0xd0, 0x79, 0x34, 0x2e, 0xf7, 0xa1, 0xa5, 0x4a, 0xa6, 0xf6, 0xe6, 0xb3,
  0x4f, 0x08, 0x5d, 0xa1, 0xbd, 0xc7, 0x2a, 0x0d, 0xed, 0xb0, 0x36, 0x13,
  0x41, 0xf8, 0x8b, 0xc4, 0x63, 0xc8, 0xf3, 0x7f, 0x96, 0xce, 0x89, 0xa4,
  0x23, 0xd2, 0xdf, 0xce, 0x2e, 0x08, 0xc5, 0xd0, 0x8f, 0xeb, 0x28, 0x62,
  0xa7, 0x12, 0x0b, 0x8f, 0x0a, 0x52, 0xe2, 0x9f, 0xe8, 0x20, 0x08, 0xb5,
  0xab, 0x2e, 0x59, 0xed, 0x94, 0x35, 0x51, 0xbd, 0x79, 0xdd, 0x3e, 0xdc,
  0xbb, 0xea, 0x22, 0x5c, 0x75, 0xf9, 0xc7, 0x6e, 0x68, 0x66, 0xe0, 0xc6,
  0xba, 0xb6, 0x18, 0xae, 0xe1, 0xe9, 0x2c, 0x4f, 0x25, 0x8c, 0x23, 0x15,
  0x73, 0x2a, 0xb3, 0x6c, 0x2e, 0xf9, 0xd2, 0x5a, 0x7e, 0x7b, 0xf5, 0x0d,
  0x70, 0x56, 0xd2, 0xc0, 0x6c, 0x01, 0x00, 0x00
};
#define logo_svg_gz_len 707
const uint8_t logo_svg_gz[] PROGMEM {
  0x1f, 0x8b, 0x08, 0x08, 0x3b, 0x8f, 0x74, 0x5a, 0x00, 0x03, 0x6c, 0x6f,
  0x67, 0x6f, 0x2e, 0x73, 0x76, 0x67, 0x00, 0xbd, 0x54, 0xc1, 0x72, 0xdb,
  0x20, 0x10, 0xbd, 0xe7, 0x2b, 0x18, 0x72, 0x49, 0x0e, 0x20, 0x40, 0x08,
  0x24, 0x37, 0x4a, 0x66, 0x7a, 0x68, 0x4f, 0x9d, 0x1e, 0xda, 0x7c, 0x00,
  0x91, 0x91, 0xc5, 0x44, 0x11, 0xae, 0x44, 0x2c, 0x27, 0x5f, 0xdf, 0x05,
  0xc9, 0xf1, 0x64, 0x92, 0x6b, 0x3b, 0x1e, 0xaf, 0x97, 0x65, 0xf7, 0xf1,
  0x1e, 0xbb, 0xf8, 0xe6, 0xee, 0xf8, 0xd4, 0xa3, 0x83, 0x1d, 0x27, 0xe7,
  0x87, 0x1a, 0x73, 0xca, 0x30, 0xb2, 0x43, 0xe3, 0xb7, 0x6e, 0xd8, 0xd5,
  0xf8, 0xfe, 0xf7, 0x37, 0x52, 0xe2, 0xbb, 0xdb, 0x8b, 0x9b, 0xe9, 0xb0,
  0x43, 0xb3, 0xdb, 0x86, 0xae, 0xc6, 0x4a, 0x62, 0xd4, 0x59, 0xb7, 0xeb,
  0xc2, 0xe2, 0x1f, 0x9c, 0x9d, 0xbf, 0xfa, 0x63, 0x8d, 0x19, 0x62, 0x88,
  0x2b, 0x5a, 0xe5, 0x8b, 0xc5, 0x08, 0xa0, 0x87, 0xa9, 0xc6, 0x5d, 0x08,
  0xfb, 0x4d, 0x96, 0xcd, 0xf3, 0x4c, 0xe7, 0x9c, 0xfa, 0x71, 0x97, 0x09,
  0xc6, 0x58, 0x06, 0x90, 0x6b, 0xca, 0xc6, 0x4f, 0x0f, 0xef, 0xd2, 0xfc,
  0xde, 0x0e, 0xd3, 0x6c, 0x42, 0xd3, 0x3d, 0x78, 0xff, 0x98, 0x4a, 0x9e,
  0x47, 0x17, 0xcb, 0xaa, 0x0c, 0x72, 0x4f, 0x65, 0xc7, 0xde, 0x0d, 0x8f,
  0x9f, 0xe1, 0xf3, 0xaa, 0xaa, 0xb2, 0xb4, 0x8b, 0x81, 0xfb, 0xd6, 0xb6,
  0x13, 0xfc, 0xc0, 0xd2, 0x9a, 0xf1, 0xfb, 0x68, 0xb6, 0xce, 0x0e, 0x01,
  0xb9, 0x6d, 0x8d, 0x0d, 0x20, 0x71, 0x50, 0x2d, 0x19, 0x15, 0x1a, 0x7c,
  0x01, 0x7e, 0xa1, 0xa9, 0xc0, 0xe8, 0x25, 0x86, 0xb5, 0xa0, 0x52, 0x81,
  0x2f, 0xce, 0xfe, 0x6e, 0x2d, 0xbf, 0x1f, 0x5c, 0x00, 0x69, 0xcf, 0x93,
  0x1d, 0x7f, 0xed, 0x4d, 0x63, 0x7f, 0x0e, 0xf7, 0x93, 0x8d, 0x87, 0x4d,
  0xc1, 0xef, 0x51, 0x34, 0xa4, 0xf1, 0xbd, 0x1f, 0x6b, 0x7c, 0x29, 0x94,
  0x51, 0x15, 0x9c, 0xe4, 0xdb, 0x76, 0xb2, 0x70, 0x67, 0x0c, 0x67, 0x90,
  0x97, 0xbd, 0xa7, 0x13, 0x23, 0x2b, 0xcf, 0x1d, 0x0a, 0xa3, 0x19, 0xa6,
  0xd6, 0x8f, 0x4f, 0x35, 0x4e, 0x6e, 0x6f, 0x82, 0xbd, 0x22, 0x0b, 0x4b,
  0x44, 0xb8, 0x92, 0xd7, 0xf1, 0xa4, 0xd1, 0x36, 0x01, 0x1d, 0x17, 0xf6,
  0x05, 0xb0, 0x04, 0x4f, 0x49, 0x2a, 0x80, 0xfc, 0xda, 0x28, 0xe8, 0x82,
  0xd4, 0xe7, 0x5e, 0xad, 0xcb, 0x31, 0x26, 0x52, 0x09, 0x69, 0xad, 0xeb,
  0x7b, 0xe0, 0xd7, 0x56, 0xf1, 0x83, 0x81, 0xf4, 0xe8, 0x1f, 0x2d, 0x68,
  0x1a, 0xfb, 0xab, 0x4b, 0x73, 0x7d, 0x0a, 0x90, 0x48, 0xb4, 0x31, 0xfb,
  0x1a, 0x4f, 0x7f, 0x9e, 0xcd, 0x68, 0xdf, 0xe2, 0xeb, 0x29, 0x11, 0x34,
  0x4b, 0xb4, 0x57, 0xbc, 0x93, 0xde, 0xd6, 0x0f, 0x81, 0xb4, 0xe6, 0xc9,
  0xf5, 0x70, 0xe2, 0x2f, 0x90, 0xb1, 0x86, 0xe6, 0x95, 0x8f, 0x64, 0x2c,
  0xca, 0xd8, 0x9b, 0xd0, 0x21, 0xe8, 0xc5, 0x0f, 0x2e, 0x4b, 0x5a, 0x0a,
  0xc4, 0x35, 0xa3, 0xb9, 0x6a, 0x08, 0xa7, 0x5c, 0x23, 0x46, 0x04, 0x15,
  0x12, 0x8e, 0x20, 0x39, 0x65, 0x30, 0x57, 0xb0, 0xe8, 0x69, 0xa9, 0x69,
  0xa9, 0x4c, 0x4e, 0xb9, 0x40, 0xc9, 0xa4, 0xb9, 0x43, 0x12, 0xaa, 0x20,
  0x27, 0x6e, 0x93, 0xb8, 0x0f, 0xeb, 0x1c, 0x25, 0x13, 0xf7, 0x59, 0x04,
  0xd0, 0x00, 0x2a, 0xf4, 0x2b, 0xb4, 0x02, 0x06, 0xbe, 0xed, 0xfd, 0x5c,
  0xe3, 0x83, 0x9b, 0xdc, 0x43, 0x9f, 0x44, 0xbd, 0xf4, 0x20, 0x3e, 0xd8,
  0x63, 0x20, 0x5b, 0xdb, 0xf8, 0xd1, 0x04, 0x78, 0x11, 0x49, 0xfc, 0x66,
  0xf0, 0x83, 0xfd, 0x92, 0x76, 0xdc, 0xb0, 0x85, 0x66, 0x6d, 0xd8, 0xb2,
  0x7a, 0xeb, 0x53, 0xca, 0x48, 0xb7, 0xf0, 0x41, 0x8d, 0xd2, 0xb4, 0x32,
  0x8a, 0x96, 0x28, 0x7e, 0x17, 0x26, 0x92, 0xea, 0x12, 0xa4, 0x54, 0x6a,
  0x91, 0xa2, 0x4d, 0x41, 0x8b, 0x02, 0x25, 0xb3, 0x48, 0x81, 0x60, 0x71,
  0x96, 0xa2, 0x3f, 0x94, 0x97, 0x44, 0xfc, 0x67, 0x11, 0x05, 0x95, 0xd2,
  0x54, 0x71, 0xfc, 0x92, 0x59, 0x88, 0x28, 0x5a, 0xe4, 0x48, 0x50, 0x55,
  0x9e, 0x74, 0x94, 0x94, 0x71, 0x94, 0xcc, 0xa2, 0xa3, 0xa0, 0x4a, 0x41,
  0x03, 0x73, 0x81, 0x4a, 0x54, 0x9e, 0x63, 0x15, 0x14, 0xe5, 0xf2, 0xad,
  0x51, 0x9f, 0xc0, 0xc6, 0x2a, 0xcd, 0xff, 0xa9, 0xc6, 0x6c, 0xf7, 0x5e,
  0x28, 0x08, 0x90, 0xa9, 0x5b, 0x85, 0xe8, 0x09, 0x4c, 0x0d, 0xe5, 0xb1,
  0x47, 0x1c, 0xa8, 0x32, 0x45, 0x0a, 0xe0, 0x27, 0xbb, 0x38, 0x92, 0xea,
  0x40, 0x73, 0xdd, 0x71, 0xa0, 0x97, 0x1f, 0x48, 0x74, 0x63, 0xb0, 0xe8,
  0x49, 0x41, 0x20, 0x23, 0x16, 0x90, 0x54, 0x00, 0x00, 0x04, 0xe6, 0x97,
  0xd0, 0x2a, 0xa2, 0x94, 0xf9, 0xeb, 0x53, 0xf4, 0x14, 0xd5, 0x3d, 0xdc,
  0x57, 0x1c, 0xcb, 0x0a, 0xe0, 0x0a, 0x2a, 0xd4, 0xeb, 0xf9, 0xdd, 0x5d,
  0xb6, 0x6d, 0xfb, 0xe1, 0x71, 0x71, 0x75, 0x66, 0x1b, 0xff, 0x31, 0x6f,
  0x2f, 0xfe, 0x02, 0xdc, 0x6a, 0x94, 0x1e, 0xb2, 0x05, 0x00, 0x00
};
