// A small Arduino Leonardo based program which uses a rotary encoder to control the volume of a PC.
// Assumes the use of a rotary encoder with a push button, to allow muting.
// I used a clone Arduino Pro Micro (ATMega32U4), which are available for peanuts on eBay. 
//
// Use the code as you please - loiphin :)



#include <Encoder.h>
// The rotary encoder library http://www.pjrc.com/teensy/td_libs_Encoder.html

//#include<HID.h>
#include <HID-Project.h>
// The HID library which produces the multimedia keys (Volume UP,DOWN and MUTE)  https://github.com/NicoHood/HID

int accel = 2;
// This is an acceleration factor. Use between 1 and 8 to suit how quickly the volume goes up or down.

int mutePin = 10;
// The digital pin to which the rotary encoder push button is connected too. Assumes that the pin has a pull-down resistor.

Encoder myEnc(2, 3);
// These are the pins to which the rotary encoder is connected.
// Pins 2,3 are the interrupt pins on a Leonardo/Uno, which give best performance with a rotary encoder. 
// Use other pins if you wish, but performance may suffer.
// Avoid using pins that have LED's attached.

long oldPosition  = -999;
int buttonState;
int lastButtonState = LOW;
long lastDebounceTime = 0;
long debounceDelay = 80;  // Button debounce time in millseconds. Increase if mute button doesnt work properly.



void setup() {
  pinMode(mutePin, INPUT);
  digitalWrite(mutePin, HIGH);
  digitalWrite(2, HIGH);
  digitalWrite(3, HIGH);  
  
  Serial.begin(9600);
  Serial.println("Debug Output:");
  
  Consumer.begin();
  
}



void loop() {
  long newPosition = myEnc.read() / accel;
  if (newPosition != oldPosition) {
    
    if(newPosition > oldPosition) {
      Consumer.write(MEDIA_VOLUME_UP);
    }
    
    if(oldPosition > newPosition) {
     Consumer.write(MEDIA_VOLUME_DOWN);
    }
    
    oldPosition = newPosition;
    Serial.println(newPosition);
    
  }
  
  // read the state of the switch into a local variable:
  int reading = digitalRead(mutePin);

  // check to see if you just pressed the button 
  // (i.e. the input went from LOW to HIGH),  and you've waited 
  // long enough since the last press to ignore any noise:  

  // If the switch changed, due to noise or pressing:
  if (reading != lastButtonState) {
    // reset the debouncing timer
    lastDebounceTime = millis();
  } 
  
  if ((millis() - lastDebounceTime) > debounceDelay) {
    // whatever the reading is at, it's been there for longer
    // than the debounce delay, so take it as the actual current state:

    // if the button state has changed:
    if (reading != buttonState) {
      buttonState = reading;

      // Toggle MUTE if digital pin reads HIGH
      if (buttonState == HIGH) {
        Consumer.write(MEDIA_VOLUME_MUTE);
      }
    }
  }
  
  // save the reading.  Next time through the loop,
  // it'll be the lastButtonState:
  lastButtonState = reading;
}
