#include <BasicButton.h>
#include <Button.h>
#include <ButtonEventCallback.h>

#include <Keyboard.h>

// A simple Arduino Leonardo based program to use two rotary encoders with push buttons and three additional buttons to operate XCSoar. 
// This tutorial was very helpful: http://www.loiph.in/2014/09/arduino-leonardo-atmega32u4-based-usb.html
// Modified by Stefan Langer; www.stefly.aero



#include <Encoder.h>
// The rotary encoder library http://www.pjrc.com/teensy/td_libs_Encoder.html

#include <Keyboard.h>


int accel = 2;
// This is an acceleration factor. Use between 1 and 8 to suit how quickly the volume goes up or down.

int mutePin = 8;
int mutePin2 = 9;
// The digital pin to which the rotary encoder push button is connected too. Assumes that the pin has a pull-down resistor.

int Task = 15;
int QuickMenu = 14;
int ESC = 16;
int debounce_delay = 300;

Encoder myEnc(3, 2);

// These are the pins to which the rotary encoder is connected.
// Pins 2,3 are the interrupt pins on a Leonardo/Uno, which give best performance with a rotary encoder. 
// Use other pins if you wish, but performance may suffer.
// Avoid using pins that have LED's attached.

long oldPosition  = -999;
int buttonState;
int lastButtonState = LOW;
long lastDebounceTime = 0;
long debounceDelay = 80;  // Button debounce time in millseconds. Increase if mute button doesnt work properly.

Encoder myEnc2(1, 0);


long oldPosition2  = -999;
int buttonState2;
int lastButtonState2 = LOW;
long lastDebounceTime2 = 0;
long debounceDelay2 = 80;

void setup() {
  pinMode(mutePin, INPUT_PULLUP);
  pinMode(mutePin2, INPUT_PULLUP);
  pinMode(QuickMenu, INPUT_PULLUP);
  pinMode(ESC, INPUT_PULLUP);
  pinMode(Task, INPUT_PULLUP);
  
  Serial.begin(9600);
  Serial.println("Debug Output:");
  
  
}



void loop() {
  long newPosition = myEnc.read() / accel;
  if (newPosition != oldPosition) {
    
    if(newPosition > oldPosition) {
      Keyboard.write(KEY_UP_ARROW);  //Schnittstelle zu xci-file; ASCII 0x32
    }
    
    if(oldPosition > newPosition) {
     Keyboard.write(KEY_DOWN_ARROW);  //ASCII 0x31
    }
    
    oldPosition = newPosition;
    Serial.println(newPosition);
    
  }
  

   long newPosition2 = myEnc2.read() / accel;
  if (newPosition2 != oldPosition2) {
    
    if(newPosition2 > oldPosition2) {
      Keyboard.write(KEY_LEFT_ARROW);  //Schnittstelle zu xci-file; ASCII 0x32
    }
    
    if(oldPosition2 > newPosition2) {
     Keyboard.write(KEY_RIGHT_ARROW);  //ASCII 0x31
    }
    
    oldPosition2 = newPosition2;
    Serial.println(newPosition2);
    
    }
  
   if (digitalRead(mutePin) == LOW)
  {
    Keyboard.write(KEY_RETURN);  // send a 'm' to the computer via Keyboard HID
    delay(debounce_delay);  // delay so there aren't a kajillion z's
  }
  
if (digitalRead(mutePin2) == LOW)
  {
    Keyboard.write(KEY_RETURN);  // send a 'm' to the computer via Keyboard HID
    delay(debounce_delay);  // delay so there aren't a kajillion z's
  }

  if (digitalRead(QuickMenu) == LOW)
  {
    Keyboard.write(KEY_F6);  // send a 'm' to the computer via Keyboard HID
    delay(debounce_delay);  // delay so there aren't a kajillion z's
  }
  if (digitalRead(ESC) == LOW)
  {
    Keyboard.write(KEY_F1);  // send a 'ESC' to the computer via Keyboard HID
    delay(debounce_delay);  // delay so there aren't a kajillion z's
  }
  if (digitalRead(Task) == LOW)
  {
    Keyboard.write(KEY_ESC);  // send a 'F7' to the computer via Keyboard HID
    delay(debounce_delay);  // delay so there aren't a kajillion z's
  }
}





