from odoo import models, fields

class res_config_settings(models.TransientModel):
    _inherit = 'res.config.settings'

    gfk_sftp_host = fields.Char(
        'SFTP Server',
        related="company_id.gfk_sftp_host",
        help=(
            "The host name or IP address from your remote"
            " server. For example 192.168.0.1"
        ),
        readonly=False
    )
    gfk_sftp_port = fields.Integer(
        "SFTP Port",
        related="company_id.gfk_sftp_port",
        default=22,
        help="The port on the FTP server that accepts SSH/SFTP calls.",
        readonly=False
    )
    gfk_sftp_user = fields.Char(
        'Username in the SFTP Server',
        related="company_id.gfk_sftp_user",
        help=(
            "The username where the SFTP connection "
            "should be made with. This is the user on the external server."
        ),
        readonly=False
    )
    gfk_sftp_password = fields.Char(
        "SFTP Password",
        related="company_id.gfk_sftp_password",
        help="The password for the SFTP connection. If you specify a private "
             "key file, then this is the password to decrypt it.",
        readonly=False
    )
    gfk_sftp_folder = fields.Char(
        'SFTP Folder',
        related="company_id.gfk_sftp_folder",
        help=(
            "The host name or IP address from your remote"
            " server. For example 192.168.0.1"
        ),
        readonly=False
    )
    gfk_base_on_ids = fields.Many2many(
        related="company_id.gfk_base_on_ids",
        readonly=False)

    gfk_brand_field_id = fields.Many2one(
        related="company_id.gfk_brand_field_id",
        readonly=False)

    gfk_category_exclude = fields.Many2many(
        related="company_id.gfk_category_exclude",
        readonly=False
        )

    gfk_store_attachment = fields.Boolean(
        related="company_id.gfk_store_attachment",
        string='Store Attachment',
        readonly=False
    )
