# -*- coding: utf-8 -*-
"""Setup tests for this package."""
from idiap.theme.testing import IDIAP_THEME_INTEGRATION_TESTING  # noqa
from plone import api

import unittest


class TestSetup(unittest.TestCase):
    """Test that idiap.theme is properly installed."""

    layer = IDIAP_THEME_INTEGRATION_TESTING

    def setUp(self):
        """Custom shared utility setup for tests."""
        self.portal = self.layer['portal']
        self.installer = api.portal.get_tool('portal_quickinstaller')

    def test_product_installed(self):
        """Test if idiap.theme is installed."""
        self.assertTrue(self.installer.isProductInstalled(
            'idiap.theme'))

    def test_browserlayer(self):
        """Test that IIdiapThemeLayer is registered."""
        from idiap.theme.interfaces import (
            IIdiapThemeLayer)
        from plone.browserlayer import utils
        self.assertIn(IIdiapThemeLayer, utils.registered_layers())


class TestUninstall(unittest.TestCase):

    layer = IDIAP_THEME_INTEGRATION_TESTING

    def setUp(self):
        self.portal = self.layer['portal']
        self.installer = api.portal.get_tool('portal_quickinstaller')
        self.installer.uninstallProducts(['idiap.theme'])

    def test_product_uninstalled(self):
        """Test if idiap.theme is cleanly uninstalled."""
        self.assertFalse(self.installer.isProductInstalled(
            'idiap.theme'))

    def test_browserlayer_removed(self):
        """Test that IIdiapThemeLayer is removed."""
        from idiap.theme.interfaces import IIdiapThemeLayer
        from plone.browserlayer import utils
        self.assertNotIn(IIdiapThemeLayer, utils.registered_layers())
