import logging
from plone.app.vocabularies.catalog import CatalogSource
from plone.supermodel import model
from zope import schema
from zope.interface import implements
from plone.app.standardtiles.utils import PermissionChecker
from plone.autoform.interfaces import READ_PERMISSIONS_KEY
from plone.tiles import Tile
from z3c.form.form import DisplayForm
from plone.app.standardtiles.existingcontent import ExistingContentTile
from plone.app.standardtiles.field import DexterityFieldTile
from zope.i18nmessageid import MessageFactory
from plone.supermodel.utils import mergedTaggedValueDict
from zope.schema.interfaces import IContextSourceBinder
from Products.CMFCore.utils import getToolByName
from plone.autoform.view import WidgetsView
from plone.dexterity.interfaces import IDexterityFTI
from plone.dexterity.utils import getAdditionalSchemata
from zope.component import queryUtility
from z3c.form.field import Fields
from z3c.form import field
from zope.component import getUtility
from zope.component import getMultiAdapter
from zope.schema.vocabulary import SimpleVocabulary
from zope.schema.vocabulary import SimpleTerm
from collective.behavior.sql.interfaces import ISQLConnectionsUtility
from plone.dexterity.utils import iterSchemataForType
from zope.schema.interfaces import IURI, ITuple
_z = MessageFactory('z3c.form')
LOG = logging.getLogger(__name__)

class FieldsSourceBinder(object):
    implements(IContextSourceBinder)

    def __call__(self, context):
        terms = []
        dones = []
        for iface in iterSchemataForType(context.portal_type):
            for name in iface.names():
                if name not in dones:
                    field = iface[name]
                    terms.append(SimpleTerm(name,name,field.title))
                    dones.append(name)
        return SimpleVocabulary(terms)


class FieldsURLSourceBinder(object):
    implements(IContextSourceBinder)

    def __call__(self, context):
        terms = []
        for iface in iterSchemataForType(context.portal_type):
            for name in iface.names():
                field = iface[name]
                if IURI.providedBy(field):
                    terms.append(SimpleTerm(name,name,field.title))
        return SimpleVocabulary(terms)


class FieldsTupleSourceBinder(object):
    implements(IContextSourceBinder)

    def __call__(self, context):
        terms = []
        for iface in iterSchemataForType(context.portal_type):
            for name in iface.names():
                field = iface[name]
                if ITuple.providedBy(field):
                    terms.append(SimpleTerm(name,name,field.title))
        return SimpleVocabulary(terms)


class IFieldLabelTile(model.Schema):

    show_label = schema.Bool(
        title=u"Show Label",
        default=True
        )

    fieldname = schema.Choice(
        title=_z(u"Schema Field"),
        source=FieldsSourceBinder(),
        )


class FieldLabelTile(Tile):

    @property
    def schema(self):
        fti = getUtility(IDexterityFTI, name=self.context.portal_type)
        return fti.lookupSchema()

    @property
    def additionalSchemata(self):
        return getAdditionalSchemata(context=self.context)

    @property
    def fields(self):
        name = self.data.get('fieldname', '')
        fields = field.Fields()
        if name in self.schema:
            fields = field.Fields(self.schema)
            fields = fields.select(name)
        else:
            for schema in self.additionalSchemata:
                if name in schema:
                    fields = field.Fields(schema)
                    fields = fields.select(name)
        return fields

    def __call__(self, *args, **kwargs):
        form = DisplayForm(self.context, self.request)
        form.fields = self.fields
        form.update()
        widget = form.widgets[self.data.get('fieldname', '')]
        if widget.value:
            self.visible = True
            self.label = widget.label
            self.widget = widget.render()
        else:
            self.visible = False
        return super(FieldLabelTile, self).__call__(*args, **kwargs)


class IImageURLTile(IFieldLabelTile):
    """"""

class ImageURLTile(FieldLabelTile):
    """Image URL Tile"""
    
    @property
    def fieldurl(self):
        if self.data.get('fieldname', ''):
            return getattr(self.context, self.data['fieldname'], '')


class ITupleKeywordsTile(IFieldLabelTile):
    """"""

class TupleKeywordsTile(FieldLabelTile):
    """Tuple Tile"""

    
    @property
    def keywords(self):
        if self.data.get('fieldname', ''):
            return getattr(self.context, self.data['fieldname'], tuple([]))
    
    @property
    def portal_url(self):
        return getToolByName(self.context, 'portal_url')()


class IDateFormattedTile(IFieldLabelTile):
    """"""

class DateFormattedTile(FieldLabelTile):
    """Image URL Tile"""
    
    @property
    def date(self):
        if self.data.get('fieldname', ''):
            date = getattr(self.context, self.data['fieldname'], '')
            if date:
                plone_view = getMultiAdapter((self.context, self.request), name=u"plone")
                return plone_view.toLocalizedTime(date.strftime('%Y-%m-%d'), long_format=0, time_only=False)
        return ''

