# -*- coding: utf-8 -*-
from Products.CMFPlone.interfaces import INonInstallable
from zope.interface import implementer
from StringIO import StringIO
from Products.CMFCore.utils import getToolByName

@implementer(INonInstallable)
class HiddenProfiles(object):

    def getNonInstallableProfiles(self):
        """Hide uninstall profile from site-creation and quickinstaller"""
        return [
            'idiap.theme:uninstall',
        ]


def post_install(context):
    """Post install script"""
    portal_quickinstaller = getToolByName(context, 'portal_quickinstaller')
    if not portal_quickinstaller.isProductInstalled('plone.app.mosaic'):
        portal_quickinstaller.installProduct('plone.app.mosaic')
    if not portal_quickinstaller.isProductInstalled('Solgema.RichMenu'):
        portal_quickinstaller.installProduct('Solgema.RichMenu')
    # Do something at the end of the installation of this package.


def uninstall(context):
    """Uninstall script"""
    # Do something at the end of the uninstallation of this package.
