# -*- coding: utf-8 -*-
import logging
from zope.component import getUtility
from zope.i18nmessageid import MessageFactory
from zope.interface import implementer
from zope.component.hooks import getSite
from Products.CMFCore.utils import getToolByName
from zope.schema.interfaces import IVocabularyFactory
from zope.schema.vocabulary import SimpleTerm
from zope.schema.vocabulary import SimpleVocabulary
from plone.dexterity.utils import iterSchemataForType
from z3c.relationfield.interfaces import IRelationChoice, IRelationList
from plone.uuid.interfaces import IUUID

from plone.registry.interfaces import IRegistry
from Products.CMFPlone.interfaces import IEditingSchema

_ = MessageFactory('idiap.theme')
LOG = logging.getLogger(__name__)

@implementer(IVocabularyFactory)
def FundingsVocabulary( context ):
    context = getSite()
    catalog = getToolByName(context, "portal_catalog")
    results = catalog.searchResults(portal_type='project')
    fundings = set()
    for a in results:
        if not a:
            funding = 'other'
        else:
            try:
                funding = str(a.funding)
            except:
                try:
                    funding = a.funding.encode('utf-8')
                except:
                    funding = a.funding.decode('utf-8')
        fundings.add(funding)
    return SimpleVocabulary([SimpleTerm(a, a, a) for a in list(fundings)])

def RelatedItemsVocabulary(context, portal_type):
    context = getSite()
    catalog = getToolByName(context, "portal_catalog")
    results = catalog.searchResults(portal_type=portal_type)
    groups = [SimpleTerm('self', 'self', 'Context')]
    for a in results:
        uid = a.UID
        try:
            title = str(a.Title)
        except:
            try:
                title = a.Title.encode('utf-8')
            except:
                title = a.Title.decode('utf-8')
        groups.append(SimpleTerm(uid, uid, title))
    return SimpleVocabulary(groups)

@implementer(IVocabularyFactory)
def RelatedGroupsVocabulary( context ):
    return RelatedItemsVocabulary(context, 'group')

@implementer(IVocabularyFactory)
def RelatedProjectsVocabulary( context ):
    return RelatedItemsVocabulary(context, 'projects')

@implementer(IVocabularyFactory)
def RelatedPeopleVocabulary( context ):
    return RelatedItemsVocabulary(context, 'people')

