# -*- coding: utf-8 -*-
from StringIO import StringIO
from Products.CMFPlone.interfaces import INonInstallable
from Products.CMFCore.interfaces import ISiteRoot
from plone.registry.interfaces import IRegistry
from Products.CMFPlone.utils import _createObjectByType
from Products.CMFPlone.interfaces import ILanguageSchema
from plone.app.multilingual.browser.setup import SetupMultilingualSite
from plone.dexterity.utils import createContent
from collective.saconnect.interfaces import ISQLAlchemyConnectionStrings
from Products.CMFCore.utils import getToolByName
from zope.component import getUtility
from zope.globalrequest import getRequest
from plone.app.mosaic.interfaces import IMosaicLayer
from plone.app.mosaic.utils import getPersistentResourceDirectory
from plone.app.blocks.interfaces import CONTENT_LAYOUT_RESOURCE_NAME
from plone.resource.manifest import MANIFEST_FILENAME
from plone.app.blocks.layoutbehavior import ILayoutAware
from plone.app.contenttypes.setuphandlers import addContentToContainer, _publish
from Products.Five.utilities import marker
from zope.container.interfaces import INameChooser
from collective.behavior.sql.content import ISQLTraverser, ISQLTypeSettings
from zope.annotation.interfaces import IAnnotations
from plone.app.blocks.utils import resolveResource
from zope.interface import alsoProvides
from zope.interface import implementer


@implementer(INonInstallable)
class HiddenProfiles(object):

    def getNonInstallableProfiles(self):
        """Hide uninstall profile from site-creation and quickinstaller"""
        return [
            'idiap.initialcontent:uninstall',
            'idiap.initialcontent:finalize',
        ]

def customWriteFile(custom, name):
    custom.writeFile(
        name+'.html',
        StringIO(resolveResource('++contentlayout++idiaplayouts/%s.html' % name)
                 .encode('utf-8'))
    )
    custom.writeFile(
        name+'.png',
        StringIO(resolveResource('++contentlayout++idiaplayouts/%s.png' % name))
    )

def create_ttw_content_layout(portal):
    request = getRequest()
    alsoProvides(request, IMosaicLayer)

    contentlayout = getPersistentResourceDirectory(CONTENT_LAYOUT_RESOURCE_NAME)
    custom = getPersistentResourceDirectory('custom', contentlayout)
    base = custom.readFile(MANIFEST_FILENAME)
    custom_manifest = resolveResource('++contentlayout++idiaplayouts/manifest.cfg')
    for name in ['project', 'group', 'person']:
        customWriteFile(custom, name)
        index = custom_manifest.find('title = %s layout' % name.capitalize())+8
        custom_manifest = custom_manifest[:index] + 'Custom ' + custom_manifest[index:]
    custom.writeFile(MANIFEST_FILENAME, StringIO(base+custom_manifest
                 .encode('utf-8')))

def post_install(context):
    """Post install script"""
    portal = getToolByName(context, 'portal_url').getPortalObject()
    portal_types = getToolByName(context, 'portal_types')
    portal_setup = getToolByName(context, 'portal_setup')
    portal_quickinstaller = getToolByName(context, 'portal_quickinstaller')
    if not portal_quickinstaller.isProductInstalled('plone.app.mosaic'):
        portal_quickinstaller.installProduct('plone.app.mosaic')
    create_ttw_content_layout(context)
    registry = getUtility(IRegistry)
    settings = registry.forInterface(ILanguageSchema, prefix="plone")
    settings.available_languages = ['en', 'fr']
    if not portal_quickinstaller.isProductInstalled('plone.app.multilingual'):
        portal_quickinstaller.installProduct('plone.app.multilingual')
        setupTool = SetupMultilingualSite()
        output = setupTool.setupSite(portal)

    sql_types = ['person', 'group', 'project', 'talk', 'press']
    for typeid in sql_types:
        sql_type = portal_types.get(typeid)
        if not sql_type:
            continue
        if 'sql_connection' in [a['id'] for a in sql_type._properties]:
            continue
        sql_type._properties = sql_type._properties + (
                    {
                        'id': 'sql_connection',
                        'type': 'string',
                        'mode': 'w',
                        'label': 'SQL Connections',
                        'description': 'SQL Connections to the databases.'
                    },
                    {
                        'id': 'sql_table',
                        'type': 'string',
                        'mode': 'w',
                        'label': 'SQL Table',
                        'description': "Name of the SQL Table used for data source for "
                                       "this type."
                    },
                    {
                        'id': 'sql_id_column',
                        'type': 'string',
                        'mode': 'w',
                        'label': 'SQL ID Column',
                        'description': "The column that will be the source if ID."
                    },
                    {
                        'id': 'sql_WHERE',
                        'type': 'string',
                        'mode': 'w',
                        'label': 'WHERE',
                        'description': "Use a custom WHERE clause to filter the sql table. You must specify only the WHERE clause and not the whole query clause. Example:WHERE type = 'public'"
                    },
                    {
                        'id': 'sql_fields_columns',
                        'type': 'lines',
                        'mode': 'w',
                        'label': 'SQL Fields Columns',
                        'description': "Stores the correspondance between field and sql column."
                    },
                    {
                        'id': 'sql_folder_id',
                        'type': 'string',
                        'mode': 'w',
                        'label': "Folder Path",
                        'description': "The path of the folder that contains the sql items. If left blank, 'data-' plus the id of the type."
                    },
                    {
                        'id': 'sql_modification_timestamp_column',
                        'type': 'string',
                        'mode': 'w',
                        'label': 'SQL Modification Timestamp',
                        'description': "The column that contains the last modification date of the entry."
                    },
                )

    saStorage = ISQLAlchemyConnectionStrings(
            getUtility(ISiteRoot)
        )
    saStorage['Idiap phpmyadmin'] = 'mysql://idiap:idiappw@sqldb.idiap.ch/idiap?charset=utf'
    
    about = getattr(portal.en, 'about', None)
    if not about:
        about = createContent(
            'Folder', id='about',
            title='about',
            description='About Idiap',
    #        language=target_language.replace('_', '-').lower())
            language='en')
        about = addContentToContainer(portal.en, about)
        _publish(about)
        about.reindexObject()
    
    idiapinmedia = getattr(about, 'idiap-in-media', None)
    if not idiapinmedia:
        idiapinmedia = createContent(
            'Folder', id='idiap-in-media',
            title='Idiap in Media',
            description='',
    #        language=target_language.replace('_', '-').lower())
            language='en')
        idiapinmedia = addContentToContainer(about, idiapinmedia)
        IAnnotations(idiapinmedia)['collective.behavior.sql.sql_type'] = 'press'
        marker.mark(idiapinmedia, ISQLTraverser)
        _publish(idiapinmedia)
        idiapinmedia.reindexObject()

    aggregator = getattr(idiapinmedia, 'aggregator', None)
    if not aggregator:
        _createObjectByType('Collection', idiapinmedia,
                            id='aggregator', title='Press Articles Today',
                            description='')
        aggregator = idiapinmedia['aggregator']

        # Constrain types
        allowed_types = ['Press', ]
#        _setup_constrains(container, allowed_types)

        idiapinmedia.setOrdering('unordered')
        idiapinmedia.setDefaultPage('aggregator')
        _publish(idiapinmedia)

        aggregator.sort_on = u'effective'
        aggregator.sort_reversed = True
        aggregator.query = [
            {'i': u'portal_type',
             'o': u'plone.app.querystring.operation.selection.is',
             'v': [u'Press'],
             },
        ]
        aggregator.customViewFields = ['Title', 'source', 'date']
        aggregator.setLayout('press_listing')

        _publish(aggregator)

    people = getattr(portal.en, 'people', None)
    if not people:
        people = createContent(
            'Folder', id='people',
            title='people',
            description='People at Idiap',
    #        language=target_language.replace('_', '-').lower())
            language='en')
        people = addContentToContainer(portal.en, people)
        _publish(people)
        people.reindexObject()

    directory = getattr(people, 'directory', None)
    if not directory:
        directory = createContent(
            'Folder', id='directory',
            title='Directory',
            description='Directory of people at Idiap',
    #        language=target_language.replace('_', '-').lower())
            language='en')
        directory = addContentToContainer(people, directory)
        if not IAnnotations(directory).get('collective.behavior.sql.sql_type') == 'person':
            IAnnotations(directory)['collective.behavior.sql.sql_type'] = 'person'
            marker.mark(directory, ISQLTraverser)
        _publish(directory)
        directory.reindexObject()

    aggregator = getattr(directory, 'aggregator', None)
    if not aggregator:
        _createObjectByType('Collection', directory,
                            id='aggregator', title='Directory',
                            description='')
        aggregator = directory['aggregator']

        # Constrain types
#        allowed_types = ['Press', ]
#        _setup_constrains(container, allowed_types)

        directory.setOrdering('unordered')
        directory.setDefaultPage('aggregator')
        _publish(directory)

        aggregator.sort_on = u'sortorder'
        aggregator.sort_reversed = False
        aggregator.query = [
            {'i': u'portal_type',
             'o': u'plone.app.querystring.operation.selection.is',
             'v': [u'Person'],
             },
            {'i': u'active',
             'o': u'plone.app.querystring.operation.boolean.isTrue',
             'v': True,
             },
        ]
        aggregator.customViewFields = ['Title', 'function', 'websiteurl']
        aggregator.setLayout('table_view')

        _publish(aggregator)
        
#    groups = createContent(
#        'Folder', id='groups',
#        title='Groups',
#        description='Research Groups at Idiap',
#        language=target_language.replace('_', '-').lower())
#        language='en')
#    groups = addContentToContainer(research, groups)
#    IAnnotations(groups)['collective.behavior.sql.sql_type'] = 'group'
#    marker.mark(groups, ISQLTraverser)
#    _publish(groups)
#    groups.reindexObject()
        
    research = getattr(portal.en, 'scientific-research', None)
    if not research:
        research = createContent(
            'Folder', id='scientific-research',
            title='research',
            description='Scientific Research',
    #        language=target_language.replace('_', '-').lower())
            language='en')
        research = addContentToContainer(portal.en, research)
#    if not IAnnotations(research).get('collective.behavior.sql.sql_type') == 'group':
#        IAnnotations(research)['collective.behavior.sql.sql_type'] = 'group'
#        marker.mark(research, ISQLTraverser)
        _publish(research)
        research.reindexObject()
    
    publications = getattr(portal.en, 'publications', None)
    if not publications:
        publications = createContent(
            'Folder', id='publications',
            title='publications',
            description='News & Publications & Events',
    #        language=target_language.replace('_', '-').lower())
            language='en')
        publications = addContentToContainer(portal.en, publications)
        _publish(publications)
        publications.reindexObject()
    
    speakertalksevents = getattr(publications, 'speaker-talks-events', None)
    if not speakertalksevents:
        speakertalksevents = createContent(
            'Folder', id='speaker-talks-events',
            title='Speaker / Talks / Events',
            description='',
    #        language=target_language.replace('_', '-').lower())
            language='en')
        speakertalksevents = addContentToContainer(publications, speakertalksevents)
        IAnnotations(speakertalksevents)['collective.behavior.sql.sql_type'] = 'talk'
        marker.mark(speakertalksevents, ISQLTraverser)
        ILayoutAware(speakertalksevents).content = resolveResource('++contentlayout++idiaplayouts/talks_folder.html')
        _publish(speakertalksevents)
        speakertalksevents.reindexObject()

    portal_setup.runAllImportStepsFromProfile('profile-idiap.initialcontent:finalize')


def finalize_install(context):
    """Finalize"""
    portal = getToolByName(context, 'portal_url').getPortalObject()
    portal_types = getToolByName(context, 'portal_types')
    portal_setup = getToolByName(context, 'portal_setup')
    sql_types = ['person', 'group', 'talk', 'press']
    for typeid in sql_types:
        sql_type = portal_types.get(typeid)
        if not sql_type:
            continue
        if not sql_type.sql_folder_id:
            continue
        sql_type.sql_folder_id = '/'+portal.id+sql_type.sql_folder_id
        ISQLTypeSettings(sql_type).catalogItems()

    research = getattr(portal.en, 'scientific-research', None)
    for sql_id in [1,2,3,9,16,17,19,18]:
    
        group = createContent(
            'group', sql_id=str(sql_id),
            language='en')
        group = addContentToContainer(research, group)
        group.reindexObject()
    
    projects = getattr(research, 'projects', None)
    if not projects:
        projects = createContent(
            'Folder', id='projects',
            title='Projects',
            description='Research Projects',
    #        language=target_language.replace('_', '-').lower())
            language='en')
        projects = addContentToContainer(research, projects)
        projects.layout = 'layout_view'
        IAnnotations(projects)['collective.behavior.sql.sql_type'] = 'project'
        marker.mark(projects, ISQLTraverser)
        _publish(projects)
        projects.reindexObject()
        ILayoutAware(projects).content = resolveResource('++contentlayout++idiaplayouts/projects_folder.html')
        
    project_type = portal_types.get('project')
    if project_type and project_type.sql_folder_id:
        project_type.sql_folder_id = '/'+portal.id+project_type.sql_folder_id
        ISQLTypeSettings(project_type).catalogItems()

def uninstall(context):
    """Uninstall script"""

