import logging
from Products.CMFCore.utils import getToolByName
from zope.component.hooks import getSite
from plone.uuid.interfaces import IUUID
LOG = logging.getLogger(__name__)

def _except(context, row):
    catalog = getToolByName(getSite(), "portal_catalog")
    results = catalog.searchResults(portal_type='project')
    fundings = set()
    for a in results:
        if a.funding in row.values:
            continue
        if not a:
            funding = 'other'
        else:
            funding = a.funding
        fundings.add(funding)
    
    return {row.index: {'query': list(fundings),}}

def _relationany(context, row):
    values = []
    for value in row.values:
        if value == 'self' and getattr(context, 'sql_id', None):
            values.append(context.sql_id)
        else:
            values.append(value)

    return {row.index: {'query': values, }}

