import logging
from Products.CMFCore.interfaces import IContentish
from Products.CMFPlone.utils import safe_unicode
from Products.ZCatalog.interfaces import IZCatalog
from plone.dexterity.interfaces import IDexterityFTI
from plone.app.discussion.interfaces import IConversation, IComment
from plone.indexer import indexer
from plone.uuid.interfaces import IUUID
from zope.component import getUtility
from string import join
LOG = logging.getLogger(__name__)

def related_items(object, portal_type, field):
    out = []
    try:
        sqlfti = getUtility(IDexterityFTI, name=portal_type)
    except:
        return out
    sql_id_column = getattr(sqlfti, 'sql_id_column', 'id')
    relations = object.getSQLItemValue(field)
    if relations:
        for item in relations:
            sql_id = getattr(item, sql_id_column, None)
            if sql_id:
                out.append(str(sql_id))
    return out

@indexer(IContentish, IZCatalog)
def related_projects(object):
    return related_items(object, 'project', 'projects')

@indexer(IContentish, IZCatalog)
def related_people(object):
    return related_items(object, 'person', 'people')

@indexer(IContentish, IZCatalog)
def related_contacts(object):
    return related_items(object, 'person', 'contacts')

@indexer(IContentish, IZCatalog)
def related_groups(object):
    return related_items(object, 'group', 'groups')
